/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kafka.serialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonObjectDeserializer
implements Deserializer<JsonObject> {
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream bias = new ByteArrayInputStream(data);
        try (JsonReader reader = Json.createReader((InputStream)bias);){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
        catch (Exception e) {
            throw new SerializationException("Unable to deserialize JsonObject", (Throwable)e);
        }
    }

    public void close() {
    }
}

