/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kafka.serialization;

import com.google.protobuf.GeneratedMessageV3;
import javax.json.JsonObject;
import org.aerogear.kafka.serialization.GenericDeserializer;
import org.aerogear.kafka.serialization.GenericSerializer;
import org.aerogear.kafka.serialization.JsonObjectDeserializer;
import org.aerogear.kafka.serialization.JsonObjectSerializer;
import org.aerogear.kafka.serialization.ProtoDeserializer;
import org.aerogear.kafka.serialization.ProtoSerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CafdiSerdes
extends Serdes {
    private static final Logger logger = LoggerFactory.getLogger(CafdiSerdes.class);

    public static Serde<JsonObject> JsonObject() {
        return new JsonObjectSerde();
    }

    public static <T> Serde<T> Generic(Class<T> type) {
        return new GenericSerde<T>(type);
    }

    public static <T> Serde<T> serdeFrom(Class<T> type) {
        if (JsonObject.class.isAssignableFrom(type)) {
            return CafdiSerdes.JsonObject();
        }
        if (GeneratedMessageV3.class.isAssignableFrom(type)) {
            return new ProtoSerde<T>(type);
        }
        try {
            return Serdes.serdeFrom(type);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Class type is not supported. Using generic serdes");
            return CafdiSerdes.Generic(type);
        }
    }

    public static final class ProtoSerde<T extends GeneratedMessageV3>
    extends Serdes.WrapperSerde<T> {
        public ProtoSerde(Class<T> type) {
            super(new ProtoSerializer(), new ProtoDeserializer<T>(type));
        }
    }

    public static final class GenericSerde<T>
    extends Serdes.WrapperSerde<T> {
        public GenericSerde(Class<T> type) {
            super(new GenericSerializer<T>(type), new GenericDeserializer<T>(type));
        }
    }

    public static final class JsonObjectSerde
    extends Serdes.WrapperSerde<JsonObject> {
        public JsonObjectSerde() {
            super((Serializer)new JsonObjectSerializer(), (Deserializer)new JsonObjectDeserializer());
        }
    }
}

