/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kafka.impl;

import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@Health
@ApplicationScoped
public class KafkaCdiMetrics
implements HealthCheck {
    private final AtomicLong createdConsumers = new AtomicLong();
    private final AtomicLong startedConsumers = new AtomicLong();
    private final AtomicLong closedConsumers = new AtomicLong();

    public HealthCheckResponse call() {
        return HealthCheckResponse.named((String)"kafka-cdi").state(this.healthy()).withData("created-consumers", this.getCreatedConsumers()).withData("started-consumers", this.getStartedConsumers()).withData("closed-consumers", this.getClosedConsumers()).build();
    }

    public long getCreatedConsumers() {
        return this.createdConsumers.get();
    }

    public long getStartedConsumers() {
        return this.startedConsumers.get();
    }

    public long getClosedConsumers() {
        return this.closedConsumers.get();
    }

    public boolean healthy() {
        long created = this.getCreatedConsumers();
        long started = this.getStartedConsumers();
        long closed = this.getClosedConsumers();
        return closed == 0L && started >= created;
    }

    void consumerCreated() {
        this.createdConsumers.incrementAndGet();
    }

    void consumerStarted() {
        this.startedConsumers.incrementAndGet();
    }

    void consumerClosed() {
        this.closedConsumers.incrementAndGet();
    }
}

