/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kafka.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.aerogear.kafka.ExtendedKafkaProducer;
import org.aerogear.kafka.SimpleKafkaProducer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serializer;

public class InjectedKafkaProducer<K, V>
extends KafkaProducer
implements SimpleKafkaProducer<K, V>,
ExtendedKafkaProducer<K, V> {
    public InjectedKafkaProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valSerializer) {
        super(configs, keySerializer, valSerializer);
    }

    @Override
    public Future<RecordMetadata> send(String topic, V payload) {
        return this.send(new ProducerRecord(topic, payload));
    }

    @Override
    public Future<RecordMetadata> send(String topic, V payload, Callback callback) {
        return this.send(new ProducerRecord(topic, payload), callback);
    }

    @Override
    public Future<RecordMetadata> send(String topic, K key, V payload) {
        return this.send(new ProducerRecord(topic, key, payload));
    }

    @Override
    public Future<RecordMetadata> send(String topic, K key, V payload, Callback callback) {
        return this.send(new ProducerRecord(topic, key, payload), callback);
    }

    @Override
    public void closeProducer() {
        super.close();
    }

    @Override
    public Future<RecordMetadata> send(String topic, V payload, Map<String, byte[]> headers) {
        List headersList = headers.entrySet().stream().map(entry -> new RecordHeader((String)entry.getKey(), (byte[])entry.getValue())).collect(Collectors.toList());
        RecordHeaders recordHeaders = new RecordHeaders(headersList);
        return this.send(new ProducerRecord(topic, null, null, null, payload, (Iterable)recordHeaders));
    }

    @Override
    public Future<RecordMetadata> send(String topic, V payload, Map<String, byte[]> headers, Callback callback) {
        List headersList = headers.entrySet().stream().map(entry -> new RecordHeader((String)entry.getKey(), (byte[])entry.getValue())).collect(Collectors.toList());
        RecordHeaders recordHeaders = new RecordHeaders(headersList);
        return this.send(new ProducerRecord(topic, null, null, null, payload, (Iterable)recordHeaders), callback);
    }

    @Override
    public Future<RecordMetadata> send(String topic, K key, V payload, Map<String, byte[]> headers) {
        List headersList = headers.entrySet().stream().map(entry -> new RecordHeader((String)entry.getKey(), (byte[])entry.getValue())).collect(Collectors.toList());
        RecordHeaders recordHeaders = new RecordHeaders(headersList);
        return this.send(new ProducerRecord(topic, null, null, key, payload, (Iterable)recordHeaders));
    }

    @Override
    public Future<RecordMetadata> send(String topic, K key, V payload, Map<String, byte[]> headers, Callback callback) {
        List headersList = headers.entrySet().stream().map(entry -> new RecordHeader((String)entry.getKey(), (byte[])entry.getValue())).collect(Collectors.toList());
        RecordHeaders recordHeaders = new RecordHeaders(headersList);
        return this.send(new ProducerRecord(topic, null, null, key, payload, (Iterable)recordHeaders), callback);
    }
}

