/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kafka.cdi.extension;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerySimpleEnvironmentResolver {
    private static final Pattern PATTERN = Pattern.compile("(#[{]([^}]+)[}])");

    private VerySimpleEnvironmentResolver() {
    }

    public static String resolveVariables(String rawExpression) {
        Matcher m = PATTERN.matcher(rawExpression);
        String result = rawExpression;
        while (m.find()) {
            result = result.replace(m.group(1), VerySimpleEnvironmentResolver.resolve(m.group(2)));
        }
        return result;
    }

    private static String resolve(String variable) {
        String value = System.getProperty(variable);
        if (value == null) {
            value = System.getenv(variable);
        }
        if (value == null) {
            throw new RuntimeException("Could not resolve: " + variable);
        }
        return value;
    }
}

