/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1Service;
import io.kubernetes.client.models.V1ServiceList;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class ServiceResourceAction
implements ResourceAction {
    private final String namespace;
    private final V1Service serviceFile;
    private final CoreV1Api api = new CoreV1Api();
    private final int maxWaitSeconds;

    public ServiceResourceAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.serviceFile = YamlParser.transformYaml(resource, V1Service.class, false);
        String namespace = this.serviceFile.getMetadata().getNamespace();
        this.namespace = namespace == null ? "default" : namespace;
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1ServiceList result;
        String selector = "metadata.name=" + this.serviceFile.getMetadata().getName();
        try {
            result = this.api.listNamespacedService(this.namespace, null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Service info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
            this.pollWait();
        }
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating Service '%s'", this.serviceFile.getMetadata().getName()));
        try {
            this.api.createNamespacedService(this.namespace, this.serviceFile, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create Service: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for Service '%s' to be created", this.serviceFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Service '%s' was not created in %d seconds", this.serviceFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for Service '%s' to be deleted", this.serviceFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Service '%s' was not deleted in %d seconds", this.serviceFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting Service '%s'", this.serviceFile.getMetadata().getName()));
        try {
            this.api.deleteNamespacedService(this.serviceFile.getMetadata().getName(), this.namespace, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete Service: " + e.getResponseBody(), e);
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking Service status", e);
        }
    }
}

