/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonSyntaxException;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1PodList;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class PodResourceAction
implements ResourceAction {
    private final String namespace;
    private final V1Pod podFile;
    private final CoreV1Api api = new CoreV1Api();
    private final int maxWaitSeconds;

    public PodResourceAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.podFile = YamlParser.transformYaml(resource, V1Pod.class, false);
        String namespace = this.podFile.getMetadata().getNamespace();
        this.namespace = namespace == null ? "default" : namespace;
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1PodList result;
        String selector = "metadata.name=" + this.podFile.getMetadata().getName();
        try {
            result = this.api.listNamespacedPod(this.namespace, null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Pod info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    private boolean resourceReady() throws ResourceActionException {
        V1Pod pod;
        try {
            pod = this.api.readNamespacedPod(this.podFile.getMetadata().getName(), this.namespace, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Pod info: " + e.getResponseBody(), e);
        }
        List statuses = pod.getStatus().getContainerStatuses();
        if (statuses == null) {
            return false;
        }
        return statuses.stream().allMatch(status -> status != null && status.isReady() != false);
    }

    private void waitUntilReady() throws ResourceActionException {
        if (!this.resourceReady()) {
            System.out.println(String.format("waiting for Pod '%s' to be ready", this.podFile.getMetadata().getName()));
            Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
            this.pollWait();
            while (!this.resourceReady()) {
                if (Instant.now().isAfter(maxTime)) {
                    throw new ResourceActionException(String.format("Pod '%s' was not ready in %d seconds", this.podFile.getMetadata().getName(), this.maxWaitSeconds));
                }
                this.pollWait();
            }
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking Pod status", e);
        }
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
        }
        this.waitUntilReady();
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating Pod '%s'", this.podFile.getMetadata().getName()));
        try {
            this.api.createNamespacedPod(this.namespace, this.podFile, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create Pod: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for Pod '%s' to be created", this.podFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Pod '%s' was not created in %d seconds", this.podFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for Pod '%s' to be deleted", this.podFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Pod '%s' was not deleted in %d seconds", this.podFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting Pod '%s'", this.podFile.getMetadata().getName()));
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.propagationPolicy("Foreground");
            this.api.deleteNamespacedPod(this.podFile.getMetadata().getName(), this.namespace, deleteOptions, null, null, null, "Foreground");
        }
        catch (JsonSyntaxException deleteOptions) {
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete Pod: " + e.getResponseBody(), e);
        }
    }
}

