/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonSyntaxException;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1Namespace;
import io.kubernetes.client.models.V1NamespaceList;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class NamespaceResourceAction
implements ResourceAction {
    private final V1Namespace namespaceFile;
    private final CoreV1Api api = new CoreV1Api();
    private final int maxWaitSeconds;

    public NamespaceResourceAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.namespaceFile = YamlParser.transformYaml(resource, V1Namespace.class, false);
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1NamespaceList result;
        String selector = "metadata.name=" + this.namespaceFile.getMetadata().getName();
        try {
            result = this.api.listNamespace(null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Namespace info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
        }
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating Namespace '%s'", this.namespaceFile.getMetadata().getName()));
        try {
            this.api.createNamespace(this.namespaceFile, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create Namespace: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for Namespace '%s' to be created", this.namespaceFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Namespace '%s' was not created in %d seconds", this.namespaceFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for Namespace '%s' to be deleted", this.namespaceFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Namespace '%s' was not deleted in %d seconds", this.namespaceFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting Namespace '%s'", this.namespaceFile.getMetadata().getName()));
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.propagationPolicy("Foreground");
            this.api.deleteNamespace(this.namespaceFile.getMetadata().getName(), deleteOptions, null, null, null, "Foreground");
        }
        catch (JsonSyntaxException deleteOptions) {
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete Namespace: " + e.getResponseBody(), e);
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking Namespace status", e);
        }
    }
}

