/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonSyntaxException;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.BatchV1Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1Job;
import io.kubernetes.client.models.V1JobList;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class JobResourceAction
implements ResourceAction {
    private final String namespace;
    private final V1Job jobFile;
    private final BatchV1Api api = new BatchV1Api();
    private final int maxWaitSeconds;

    public JobResourceAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.jobFile = YamlParser.transformYaml(resource, V1Job.class, false);
        String namespace = this.jobFile.getMetadata().getNamespace();
        this.namespace = namespace == null ? "default" : namespace;
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1JobList result;
        String selector = "metadata.name=" + this.jobFile.getMetadata().getName();
        try {
            result = this.api.listNamespacedJob(this.namespace, null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Job info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    private boolean resourceReady() throws ResourceActionException {
        V1Job job;
        try {
            job = this.api.readNamespacedJob(this.jobFile.getMetadata().getName(), this.namespace, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Job info: " + e.getResponseBody(), e);
        }
        Integer succeeded = job.getStatus().getSucceeded();
        return succeeded != null && succeeded > 0;
    }

    private void waitUntilReady() throws ResourceActionException {
        if (!this.resourceReady()) {
            System.out.println(String.format("waiting for Job '%s' to be ready", this.jobFile.getMetadata().getName()));
            Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
            this.pollWait();
            while (!this.resourceReady()) {
                if (Instant.now().isAfter(maxTime)) {
                    throw new ResourceActionException(String.format("Job '%s' was not ready in %d seconds", this.jobFile.getMetadata().getName(), this.maxWaitSeconds));
                }
                this.pollWait();
            }
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking Job status", e);
        }
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
        }
        this.waitUntilReady();
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating Job '%s'", this.jobFile.getMetadata().getName()));
        try {
            this.api.createNamespacedJob(this.namespace, this.jobFile, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create Job: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for Job '%s' to be created", this.jobFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Job '%s' was not created in %d seconds", this.jobFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for Job '%s' to be deleted", this.jobFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Job '%s' was not deleted in %d seconds", this.jobFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting Job '%s'", this.jobFile.getMetadata().getName()));
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.propagationPolicy("Foreground");
            this.api.deleteNamespacedJob(this.jobFile.getMetadata().getName(), this.namespace, deleteOptions, null, null, null, "Foreground");
        }
        catch (JsonSyntaxException deleteOptions) {
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete Job: " + e.getResponseBody(), e);
        }
    }
}

