/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonSyntaxException;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.ExtensionsV1beta1Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1beta1Ingress;
import io.kubernetes.client.models.V1beta1IngressList;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class IngressResourceAction
implements ResourceAction {
    private final String namespace;
    private final V1beta1Ingress ingressFile;
    private final ExtensionsV1beta1Api api = new ExtensionsV1beta1Api();
    private final int maxWaitSeconds;

    public IngressResourceAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.ingressFile = YamlParser.transformYaml(resource, V1beta1Ingress.class, false);
        String namespace = this.ingressFile.getMetadata().getNamespace();
        this.namespace = namespace == null ? "default" : namespace;
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1beta1IngressList result;
        String selector = "metadata.name=" + this.ingressFile.getMetadata().getName();
        try {
            result = this.api.listNamespacedIngress(this.namespace, null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Ingress info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
        }
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating Ingress '%s'", this.ingressFile.getMetadata().getName()));
        try {
            this.api.createNamespacedIngress(this.namespace, this.ingressFile, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create Ingress: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for Ingress '%s' to be created", this.ingressFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Ingress '%s' was not created in %d seconds", this.ingressFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for Ingress '%s' to be deleted", this.ingressFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Ingress '%s' was not deleted in %d seconds", this.ingressFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting Ingress '%s'", this.ingressFile.getMetadata().getName()));
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.propagationPolicy("Foreground");
            this.api.deleteNamespacedIngress(this.ingressFile.getMetadata().getName(), this.namespace, deleteOptions, null, null, null, "Foreground");
        }
        catch (JsonSyntaxException deleteOptions) {
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete Ingress: " + e.getResponseBody(), e);
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking Ingress status", e);
        }
    }
}

