/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonSyntaxException;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.AppsV1beta2Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1beta2Deployment;
import io.kubernetes.client.models.V1beta2DeploymentList;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class DeploymentResourceAction
implements ResourceAction {
    private final String namespace;
    private final V1beta2Deployment deploymentFile;
    private final AppsV1beta2Api api = new AppsV1beta2Api();
    private final int maxWaitSeconds;

    public DeploymentResourceAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.deploymentFile = YamlParser.transformYaml(resource, V1beta2Deployment.class, false);
        String namespace = this.deploymentFile.getMetadata().getNamespace();
        this.namespace = namespace == null ? "default" : namespace;
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1beta2DeploymentList result;
        String selector = "metadata.name=" + this.deploymentFile.getMetadata().getName();
        try {
            result = this.api.listNamespacedDeployment(this.namespace, null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Deployment info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    private boolean resourceReady() throws ResourceActionException {
        V1beta2Deployment deployment;
        try {
            deployment = this.api.readNamespacedDeployment(this.deploymentFile.getMetadata().getName(), this.namespace, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get Deployment info: " + e.getResponseBody(), e);
        }
        Integer replicas = deployment.getStatus().getAvailableReplicas();
        return replicas != null && replicas > 0;
    }

    private void waitUntilReady() throws ResourceActionException {
        if (!this.resourceReady()) {
            System.out.println(String.format("waiting for Deployment '%s' to be ready", this.deploymentFile.getMetadata().getName()));
            Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
            this.pollWait();
            while (!this.resourceReady()) {
                if (Instant.now().isAfter(maxTime)) {
                    throw new ResourceActionException(String.format("Deployment '%s' was not ready in %d seconds", this.deploymentFile.getMetadata().getName(), this.maxWaitSeconds));
                }
                this.pollWait();
            }
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking Deployment status", e);
        }
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
        }
        this.waitUntilReady();
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating Deployment '%s'", this.deploymentFile.getMetadata().getName()));
        try {
            this.api.createNamespacedDeployment(this.namespace, this.deploymentFile, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create Deployment: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for Deployment '%s' to be created", this.deploymentFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Deployment '%s' was not created in %d seconds", this.deploymentFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for Deployment '%s' to be deleted", this.deploymentFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("Deployment '%s' was not deleted in %d seconds", this.deploymentFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting Deployment '%s'", this.deploymentFile.getMetadata().getName()));
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.propagationPolicy("Foreground");
            this.api.deleteNamespacedDeployment(this.deploymentFile.getMetadata().getName(), this.namespace, deleteOptions, null, null, null, "Foreground");
        }
        catch (JsonSyntaxException deleteOptions) {
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete Deployment: " + e.getResponseBody(), e);
        }
    }
}

