/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1ConfigMap;
import io.kubernetes.client.models.V1ConfigMapList;
import io.kubernetes.client.models.V1DeleteOptions;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class ConfigMapResourceAction
implements ResourceAction {
    private final String namespace;
    private final V1ConfigMap configMapFile;
    private final CoreV1Api api = new CoreV1Api();
    private final int maxWaitSeconds;

    public ConfigMapResourceAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.configMapFile = YamlParser.transformYaml(resource, V1ConfigMap.class, false);
        String namespace = this.configMapFile.getMetadata().getNamespace();
        this.namespace = namespace == null ? "default" : namespace;
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1ConfigMapList result;
        String selector = "metadata.name=" + this.configMapFile.getMetadata().getName();
        try {
            result = this.api.listNamespacedConfigMap(this.namespace, null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get ConfigMap info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
        }
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating ConfigMap '%s'", this.configMapFile.getMetadata().getName()));
        try {
            this.api.createNamespacedConfigMap(this.namespace, this.configMapFile, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create ConfigMap: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for ConfigMap '%s' to be created", this.configMapFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("ConfigMap '%s' was not created in %d seconds", this.configMapFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for ConfigMap '%s' to be deleted", this.configMapFile.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("ConfigMap '%s' was not deleted in %d seconds", this.configMapFile.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting ConfigMap '%s'", this.configMapFile.getMetadata().getName()));
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.propagationPolicy("Foreground");
            this.api.deleteNamespacedConfigMap(this.configMapFile.getMetadata().getName(), this.namespace, deleteOptions, null, null, null, "Foreground");
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete ConfigMap: " + e.getResponseBody(), e);
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking ConfigMap status", e);
        }
    }
}

