/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug.actions;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionException;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonSyntaxException;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.models.V1ClusterRoleBinding;
import io.kubernetes.client.models.V1ClusterRoleBindingList;
import io.kubernetes.client.models.V1DeleteOptions;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class ClusterRoleBindingAction
implements ResourceAction {
    private final V1ClusterRoleBinding clusterRoleBinding;
    private final RbacAuthorizationV1Api api = new RbacAuthorizationV1Api();
    private final int maxWaitSeconds;

    public ClusterRoleBindingAction(JsonNode resource, TugManifest.Deployment deployment) {
        this.clusterRoleBinding = YamlParser.transformYaml(resource, V1ClusterRoleBinding.class, false);
        this.maxWaitSeconds = deployment.getMaxWaitSeconds();
    }

    private boolean resourceExists() throws ResourceActionException {
        V1ClusterRoleBindingList result;
        String selector = "metadata.name=" + this.clusterRoleBinding.getMetadata().getName();
        try {
            result = this.api.listClusterRoleBinding(null, null, selector, Boolean.valueOf(true), null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to get ClusterRoleBinding info: " + e.getResponseBody());
        }
        return result.getItems().size() > 0;
    }

    @Override
    public void makeReady() throws ResourceActionException {
        if (!this.resourceExists()) {
            this.create();
            this.waitUntilCreated();
        }
    }

    private void create() throws ResourceActionException {
        System.out.println(String.format("creating ClusterRoleBinding '%s'", this.clusterRoleBinding.getMetadata().getName()));
        try {
            this.api.createClusterRoleBinding(this.clusterRoleBinding, null);
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to create ClusterRoleBinding: " + e.getResponseBody(), e);
        }
    }

    private void waitUntilCreated() throws ResourceActionException {
        System.out.println(String.format("waiting for ClusterRoleBinding '%s' to be created", this.clusterRoleBinding.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (!this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("ClusterRoleBinding '%s' was not created in %d seconds", this.clusterRoleBinding.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    @Override
    public void delete() throws ResourceActionException {
        if (this.resourceExists()) {
            this.executeDelete();
            this.waitUntilDeleted();
        }
    }

    private void waitUntilDeleted() throws ResourceActionException {
        System.out.println(String.format("waiting for ClusterRoleBinding '%s' to be deleted", this.clusterRoleBinding.getMetadata().getName()));
        Instant maxTime = Instant.now().plus((long)this.maxWaitSeconds, ChronoUnit.SECONDS);
        this.pollWait();
        while (this.resourceExists()) {
            if (Instant.now().isAfter(maxTime)) {
                throw new ResourceActionException(String.format("ClusterRoleBinding '%s' was not deleted in %d seconds", this.clusterRoleBinding.getMetadata().getName(), this.maxWaitSeconds));
            }
            this.pollWait();
        }
    }

    private void executeDelete() throws ResourceActionException {
        System.out.println(String.format("deleting ClusterRoleBinding '%s'", this.clusterRoleBinding.getMetadata().getName()));
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.propagationPolicy("Foreground");
            this.api.deleteClusterRoleBinding(this.clusterRoleBinding.getMetadata().getName(), deleteOptions, null, null, null, "Foreground");
        }
        catch (JsonSyntaxException deleteOptions) {
        }
        catch (ApiException e) {
            throw new ResourceActionException("Unable to delete ClusterRoleBinding: " + e.getResponseBody(), e);
        }
    }

    private void pollWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while checking ClusterRoleBinding status", e);
        }
    }
}

