/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class YamlParser {
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonNode parseYaml(Path location) {
        try (InputStream in = Files.newInputStream(location, new OpenOption[0]);){
            JsonNode jsonNode = objectMapper.readTree(in);
            return jsonNode;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read " + location, e);
        }
    }

    public static <T> T transformYaml(JsonNode node, Class<T> clazz, boolean validate) {
        Object value = objectMapper.convertValue((Object)node, clazz);
        if (validate) {
            YamlParser.validate(value, clazz);
        }
        return (T)value;
    }

    private static <T> void validate(T value, Class<T> clazz) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate(value, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException("Invalid " + clazz.getSimpleName(), violations);
        }
    }

    public static <T> T parseYaml(Path location, Class<T> clazz, boolean validate) {
        Object value;
        try (InputStream in = Files.newInputStream(location, new OpenOption[0]);){
            value = objectMapper.readValue(in, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read " + clazz.getSimpleName(), e);
        }
        if (validate) {
            YamlParser.validate(value, clazz);
        }
        return (T)value;
    }
}

