/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug;

import cloud.nimburst.tug.TugManifest;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={UniqueNamesValidator.class})
@Documented
public @interface UniqueNames {
    public String message() default "Deployment names must be unique";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class UniqueNamesValidator
    implements ConstraintValidator<UniqueNames, TugManifest> {
        public void initialize(UniqueNames constraintAnnotation) {
        }

        public boolean isValid(TugManifest manifest, ConstraintValidatorContext context) {
            if (manifest != null && manifest.getDeployments() != null) {
                HashSet<String> names = new HashSet<String>();
                for (String name : names) {
                    if (name == null || names.add(name)) continue;
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate("Duplicate deployment name found: " + name).addConstraintViolation();
                    return false;
                }
            }
            return true;
        }
    }
}

