/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug;

import cloud.nimburst.tug.ResourceActionDirection;
import cloud.nimburst.tug.ResourceActionGraphExecutor;
import cloud.nimburst.tug.TugAction;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class Tug {
    private final TugAction action;
    private final Path configRoot;
    private final TugManifest manifest;
    private final List<String> resources;
    private final int parallelism;

    public Tug(int parallelism, TugAction action, Path manifestPath, List<String> resources) {
        this.parallelism = parallelism;
        this.action = action;
        this.resources = resources;
        this.configRoot = manifestPath.toAbsolutePath().getParent();
        this.manifest = YamlParser.parseYaml(manifestPath, TugManifest.class, true);
        try {
            ApiClient client = Config.defaultClient();
            Configuration.setDefaultApiClient((ApiClient)client);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to configure k8s client", e);
        }
    }

    public void execute() {
        switch (this.action) {
            case PUSH: {
                this.doAction(ResourceActionDirection.CREATE);
                break;
            }
            case PULL: {
                this.doAction(ResourceActionDirection.DELETE);
                break;
            }
            case REPUSH: {
                this.doAction(ResourceActionDirection.DELETE);
                this.doAction(ResourceActionDirection.CREATE);
                break;
            }
            default: {
                throw new RuntimeException("Invalid action: " + (Object)((Object)this.action));
            }
        }
    }

    private void doAction(ResourceActionDirection dir) {
        if (dir == ResourceActionDirection.CREATE) {
            System.out.println("\ud83d\udea2 Pushing containers into port ... \ud83d\udea2");
        } else {
            System.out.println("\ud83d\udea2 Pulling containers out to sea ... \ud83d\udea2");
        }
        try {
            new ResourceActionGraphExecutor(dir, this.parallelism, this.configRoot, this.manifest, this.resources).execute();
            System.out.println("\ud83d\udea2 Toot Toot! \ud83d\udea2");
        }
        catch (Exception e) {
            System.out.println("A resource action failed. The cluster may be in an undesirable state. Manual intervention may be required.");
            throw new RuntimeException(e);
        }
    }
}

