/*
 * Decompiled with CFR 0.152.
 */
package cloud.nimburst.tug;

import cloud.nimburst.tug.ResourceAction;
import cloud.nimburst.tug.ResourceActionDirection;
import cloud.nimburst.tug.TugManifest;
import cloud.nimburst.tug.YamlParser;
import cloud.nimburst.tug.actions.ClusterRoleBindingAction;
import cloud.nimburst.tug.actions.ConfigMapResourceAction;
import cloud.nimburst.tug.actions.DeploymentResourceAction;
import cloud.nimburst.tug.actions.IngressResourceAction;
import cloud.nimburst.tug.actions.JobResourceAction;
import cloud.nimburst.tug.actions.NamespaceResourceAction;
import cloud.nimburst.tug.actions.PodResourceAction;
import cloud.nimburst.tug.actions.ServiceResourceAction;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;

public class ResourceActionGraphExecutor {
    private final DirectedAcyclicGraph<DeploymentAction, DefaultEdge> dag = new DirectedAcyclicGraph(DefaultEdge.class);
    private final Set<DeploymentAction> processing = new HashSet<DeploymentAction>();
    private final Set<DeploymentAction> initial;
    private final Map<String, DeploymentAction> deploymentActions;
    private final List<CompletableFuture<?>> futures;
    private final ExecutorService executor;
    private final Path configRoot;
    private final ResourceActionDirection dir;
    private Exception exception;
    private CompletableFuture<?> all;

    public ResourceActionGraphExecutor(ResourceActionDirection direction, int parallelism, Path configRoot, TugManifest manifest, List<String> resources) {
        this.dir = direction;
        this.configRoot = configRoot;
        this.executor = Executors.newWorkStealingPool(parallelism);
        this.deploymentActions = manifest.getDeployments().stream().map(this::deploymentToAction).collect(Collectors.toMap(da -> ((DeploymentAction)da).getDeployment().getName(), Function.identity()));
        this.deploymentActions.values().forEach(arg_0 -> this.dag.addVertex(arg_0));
        this.deploymentActions.values().forEach(da -> ((DeploymentAction)da).getDeployment().getDependencies().forEach(dep -> {
            DefaultEdge cfr_ignored_0 = (DefaultEdge)this.dag.addEdge(da, (Object)this.deploymentActions.get(dep));
        }));
        if (!resources.isEmpty()) {
            Set toKeep = resources.stream().map(this.deploymentActions::get).flatMap(da -> (this.dir == ResourceActionDirection.CREATE ? this.dag.getDescendants(da) : this.dag.getAncestors(da)).stream()).collect(Collectors.toCollection(HashSet::new));
            toKeep.addAll(resources.stream().map(this.deploymentActions::get).collect(Collectors.toCollection(HashSet::new)));
            this.futures = toKeep.stream().map(rec$ -> ((DeploymentAction)rec$).getFuture()).collect(Collectors.toList());
            HashSet<DeploymentAction> toRemove = new HashSet<DeploymentAction>(this.deploymentActions.values());
            toRemove.removeAll(toKeep);
            toRemove.forEach(arg_0 -> this.dag.removeVertex(arg_0));
        } else {
            this.futures = this.deploymentActions.values().stream().map(rec$ -> ((DeploymentAction)rec$).getFuture()).collect(Collectors.toList());
        }
        this.initial = new HashSet<DeploymentAction>();
        this.dag.forEach(v -> {
            if ((this.dir == ResourceActionDirection.CREATE ? this.dag.outgoingEdgesOf(v) : this.dag.incomingEdgesOf(v)).isEmpty()) {
                this.processing.add((DeploymentAction)v);
                this.initial.add((DeploymentAction)v);
            }
        });
    }

    private DeploymentAction deploymentToAction(TugManifest.Deployment deployment) {
        ResourceAction resourceAction;
        String kind;
        JsonNode resource;
        JsonNode kindNode;
        Path location = Paths.get(deployment.getLocation(), new String[0]);
        if (!location.isAbsolute()) {
            location = this.configRoot.resolve(location);
        }
        if ((kindNode = (resource = YamlParser.parseYaml(location)).get("kind")) == null || !kindNode.isTextual()) {
            throw new RuntimeException("No kind defined in " + location);
        }
        switch (kind = kindNode.textValue()) {
            case "Pod": {
                resourceAction = new PodResourceAction(resource, deployment);
                break;
            }
            case "Service": {
                resourceAction = new ServiceResourceAction(resource, deployment);
                break;
            }
            case "ConfigMap": {
                resourceAction = new ConfigMapResourceAction(resource, deployment);
                break;
            }
            case "Job": {
                resourceAction = new JobResourceAction(resource, deployment);
                break;
            }
            case "Deployment": {
                resourceAction = new DeploymentResourceAction(resource, deployment);
                break;
            }
            case "Ingress": {
                resourceAction = new IngressResourceAction(resource, deployment);
                break;
            }
            case "Namespace": {
                resourceAction = new NamespaceResourceAction(resource, deployment);
                break;
            }
            case "ClusterRoleBinding": {
                resourceAction = new ClusterRoleBindingAction(resource, deployment);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported deployment kind: " + kind);
            }
        }
        return new DeploymentAction(deployment, resourceAction);
    }

    public void execute() {
        try {
            this.initial.forEach(v -> this.executor.submit(() -> this.doNext((DeploymentAction)v)));
            this.all = CompletableFuture.allOf(this.futures.toArray(new CompletableFuture[this.futures.size()]));
            this.all.join();
        }
        finally {
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void doNext(DeploymentAction v) {
        if (this.exception != null) {
            v.getFuture().completeExceptionally(this.exception);
        }
        try {
            if (this.dir == ResourceActionDirection.CREATE) {
                v.getResourceAction().makeReady();
                System.out.println(v.getDeployment().getName() + " ready");
            } else {
                v.getResourceAction().delete();
                System.out.println(v.getDeployment().getName() + " deleted");
            }
            v.getFuture().complete(v);
            DirectedAcyclicGraph<DeploymentAction, DefaultEdge> directedAcyclicGraph = this.dag;
            synchronized (directedAcyclicGraph) {
                this.dag.removeVertex((Object)v);
                this.dag.forEach(nextV -> {
                    if (!this.processing.contains(nextV) && (this.dir == ResourceActionDirection.CREATE ? this.dag.outgoingEdgesOf(nextV) : this.dag.incomingEdgesOf(nextV)).isEmpty()) {
                        this.processing.add((DeploymentAction)nextV);
                        this.executor.submit(() -> this.doNext((DeploymentAction)nextV));
                    }
                });
            }
        }
        catch (Exception e) {
            this.exception = e;
            v.getFuture().completeExceptionally(e);
            this.all.completeExceptionally(e);
        }
        return null;
    }

    private static class DeploymentAction {
        private final TugManifest.Deployment deployment;
        private final ResourceAction resourceAction;
        private final CompletableFuture<DeploymentAction> future;

        private DeploymentAction(TugManifest.Deployment deployment, ResourceAction resourceAction) {
            this.deployment = deployment;
            this.resourceAction = resourceAction;
            this.future = new CompletableFuture();
        }

        private TugManifest.Deployment getDeployment() {
            return this.deployment;
        }

        private ResourceAction getResourceAction() {
            return this.resourceAction;
        }

        private CompletableFuture<DeploymentAction> getFuture() {
            return this.future;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DeploymentAction that = (DeploymentAction)o;
            return Objects.equals(this.deployment.getName(), that.deployment.getName());
        }

        public int hashCode() {
            return this.deployment.getName().hashCode();
        }
    }
}

