/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.MetaStatsClient;
import cloud.metaapi.sdk.clients.RetryOptions;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaStats {
    private static Logger logger = LogManager.getLogger(MetaStats.class);
    private MetaStatsClient metaStatsClient;

    public MetaStats(String token) {
        try {
            this.initialize(token, null);
        }
        catch (ValidationException e) {
            logger.error("Specified options are invalid", (Throwable)e);
        }
    }

    public MetaStats(String token, ConnectionOptions opts) throws ValidationException {
        this.initialize(token, opts);
    }

    public CompletableFuture<MetaStatsClient.Metrics> getMetrics(String accountId) {
        return this.metaStatsClient.getMetrics(accountId, false);
    }

    public CompletableFuture<MetaStatsClient.Metrics> getMetrics(String accountId, boolean includeOpenPositions) {
        return this.metaStatsClient.getMetrics(accountId, includeOpenPositions);
    }

    private void initialize(String token, ConnectionOptions opts) throws ValidationException {
        HttpClient httpClient = new HttpClient(opts.requestTimeout * 1000, opts.connectTimeout * 1000, opts.retryOpts);
        this.metaStatsClient = new MetaStatsClient(httpClient, token, opts.domain);
    }

    public static class ConnectionOptions {
        public int requestTimeout = 60;
        public int connectTimeout = 60;
        public String domain = "agiliumtrade.agiliumtrade.ai";
        public RetryOptions retryOpts = new RetryOptions();
    }
}

