/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MetaStatsClient {
    private HttpClient httpClient;
    private String host;
    private String token;

    public MetaStatsClient(HttpClient httpClient, String token) {
        this(httpClient, token, "agiliumtrade.agiliumtrade.ai");
    }

    public MetaStatsClient(HttpClient httpClient, String token, String domain) {
        this.httpClient = httpClient;
        this.host = "https://metastats-api-v1." + domain;
        this.token = token;
    }

    public CompletableFuture<Metrics> getMetrics(String accountId) {
        return this.getMetrics(accountId, false);
    }

    public CompletableFuture<Metrics> getMetrics(String accountId, boolean includeOpenPositions) {
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/metrics", HttpRequestOptions.Method.GET);
        opts.getQueryParameters().put("includeOpenPositions", includeOpenPositions);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, MetricsResponse.class).thenApply(metrics -> metrics.metrics);
    }

    protected static class MetricsResponse {
        public Metrics metrics;

        protected MetricsResponse() {
        }
    }

    public static class Metrics {
        public Boolean inclusive;
        public double balance;
        public String highestBalanceDate;
        public Double highestBalance;
        public double equity;
        public int trades;
        public Double withdrawals;
        public Double averageTradeLengthInMilliseconds;
        public Double bestTrade;
        public Double worstTrade;
        public Double bestTradePips;
        public Double worstTradePips;
        public String bestTradeDate;
        public String bestTradePipsDate;
        public String worstTradeDate;
        public String worstTradePipsDate;
        public Double commissions;
        public Double dailyGain;
        public Double monthlyGain;
        public Double equityPercent;
        public Double expectancy;
        public Double expectancyPips;
        public Double gain;
        public Double geometricHoldingPeriodReturn;
        public Double interest;
        public Integer longTrades;
        public Integer shortTrades;
        public Integer longWonTrades;
        public Integer shortWonTrades;
        public Double longWonTradesPercent;
        public Double shortWonTradesPercent;
        public Double maxDrawdown;
        public Double lots;
        public Double pips;
        public double profit;
        public double deposits;
        public Double absoluteGain;
        public Double profitFactor;
        public Double sharpeRatio;
        public Double sortinoRatio;
        public Double standardDeviationProfit;
        public Double kurtosisProfit;
        public Double averageHoldingPeriodReturn;
        public Double averageWin;
        public Double averageWinPips;
        public Double averageLoss;
        public Double averageLossPips;
        public Double wonTradesPercent;
        public Double lostTradesPercent;
        public Double zScore;
        public Double probability;
        public Integer daysSinceTradingStarted;
        public List<CurrencySummaryMetrics> currencySummary;
        public List<DailyGrowthMetrics> dailyGrowth;
        public List<MonthlyAnalyticsMetrics> monthlyAnalytics;
        public List<TradeByTimeMetrics> closeTradesByWeekDay;
        public List<TradeByTimeMetrics> openTradesByHour;
        public Periods periods;
        public List<RiskOfRuinMetrics> riskOfRuin;
        public TradeDurationMetrics tradeDuration;
        public List<TradeDurationDiagramColumnMetrics> tradeDurationDiagram;
    }

    public static class TradeDurationDiagramColumnMetrics {
        public int durations;
        public int trades;
        public String name;
        public int minDurationInSeconds;
        public Integer maxDurationInSeconds;
        public TradeDurationDiagramColumnCollectionMetrics won;
        public TradeDurationDiagramColumnCollectionMetrics lost;
    }

    public static class TradeDurationDiagramColumnCollectionMetrics {
        public List<Double> gains;
        public List<Double> profits;
        public List<Double> lots;
        public List<Double> pips;
    }

    public static class TradeDurationMetrics {
        public List<OneTradeDurationMetrics> won;
        public List<OneTradeDurationMetrics> lost;
    }

    public static class OneTradeDurationMetrics {
        public List<Double> gains;
        public List<Double> profits;
        public List<Double> lots;
        public List<Double> pips;
        public double durationInMinutes;
    }

    public static class RiskOfRuinMetrics {
        public double lossSize;
        public double probabilityOfLoss;
        public int consecutiveLosingTrades;
    }

    public static class TradeByTimeMetrics {
        public String date;
        public double profit;
        public Double shortProfit;
        public Double longProfit;
        public Double wonProfit;
        public Double lostProfit;
        public Double pips;
        public Double shortPips;
        public Double longPips;
        public Double wonPips;
        public Double lostPips;
        public double lots;
        public double gains;
        public Double shortGains;
        public Double longGains;
        public Double wonGains;
        public Double lostGains;
        public int trades;
        public Integer shortTrades;
        public Integer longTrades;
        public Integer wonTrades;
        public Integer lostTrades;
        public Double shortTradesPercent;
        public Double longTradesPercent;
        public Double wonTradesPercent;
        public Double lostTradesPercent;
        public Integer hour;
        public Integer day;
    }

    public static class MonthlyAnalyticsMetrics {
        public String date;
        public Double profit;
        public Double pips;
        public Double lots;
        public Double gains;
        public Integer trades;
        public List<MonthlyAnalyticCurrencyMetrics> currencies;
    }

    public static class MonthlyAnalyticCurrencyMetrics {
        public String currency;
        public Double averageHoldingTimeLongsInMilliseconds;
        public Double averageHoldingTimeShortsInMilliseconds;
        public double rewardToRiskRatio;
        public double popularityPercent;
    }

    public static class DailyGrowthMetrics {
        public String date;
        public Double profit;
        public Double pips;
        public Double lots;
        public Double gains;
        public Double totalProfit;
        public Double totalGains;
        public double balance;
        public Double drawdownPercentage;
        public Double drawdownProfit;
    }

    public static class Periods {
        public PeriodMetrics today;
        public PeriodMetrics thisWeek;
        public PeriodMetrics thisMonth;
        public PeriodMetrics thisYear;
    }

    public static class PeriodMetrics {
        public Double profit;
        public Double pips;
        public Double lots;
        public Double gain;
        public Integer trades;
        public Double wonTradesPercent;
        public Double profitDifference;
        public Double pipsDifference;
        public Double lotsDifference;
        public Double gainDifference;
        public Double tradesDifference;
        public Double wonTradesPercentDifference;
    }

    public static class CurrencySummaryMetrics {
        public String currency;
        public List<CurrencySummaryHistoryDayMetrics> history;
        public CurrencySummaryTotalMetrics total;
        @JsonProperty(value="short")
        public CurrencySummaryTradeMetrics short_;
        @JsonProperty(value="long")
        public CurrencySummaryTradeMetrics long_;
    }

    public static class CurrencySummaryTradeMetrics {
        public double profit;
        public int trades;
        public Double pips;
    }

    public static class CurrencySummaryTotalMetrics {
        public double profit;
        public int trades;
        public Double pips;
        public Integer wonTrades;
        public Integer lostTrades;
        public Double wonTradesPercent;
        public Double lostTradesPercent;
    }

    public static class CurrencySummaryHistoryDayMetrics {
        public String date;
        public double totalProfit;
        public Double totalPips;
        public Double shortProfit;
        public Double longProfit;
        public Double shortPips;
        public Double longPips;
    }
}

