/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.MetaStatsClient;
import cloud.metaapi.sdk.clients.RetryOptions;
import java.util.concurrent.CompletableFuture;

public class MetaStats {
    private MetaStatsClient metaStatsClient;

    public MetaStats(String token) {
        this(token, new ConnectionOptions());
    }

    public MetaStats(String token, ConnectionOptions opts) {
        HttpClient httpClient = new HttpClient(opts.requestTimeout * 1000, opts.connectTimeout * 1000, opts.retryOpts);
        this.metaStatsClient = new MetaStatsClient(httpClient, token, opts.domain);
    }

    public CompletableFuture<MetaStatsClient.Metrics> getMetrics(String accountId) {
        return this.metaStatsClient.getMetrics(accountId, false);
    }

    public CompletableFuture<MetaStatsClient.Metrics> getMetrics(String accountId, boolean includeOpenPositions) {
        return this.metaStatsClient.getMetrics(accountId, includeOpenPositions);
    }

    public static class ConnectionOptions {
        public int requestTimeout = 60;
        public int connectTimeout = 60;
        public String domain = "agiliumtrade.agiliumtrade.ai";
        public RetryOptions retryOpts = new RetryOptions();
    }
}

