/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderAccountClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderDemoAccountClient;
import cloud.metaapi.sdk.clients.meta_api.ProvisioningProfileClient;
import cloud.metaapi.sdk.clients.models.ValidationDetails;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.MetatraderAccountApi;
import cloud.metaapi.sdk.meta_api.MetatraderDemoAccountApi;
import cloud.metaapi.sdk.meta_api.ProvisioningProfileApi;
import java.util.ArrayList;

public class MetaApi {
    private MetaApiWebsocketClient metaApiWebsocketClient;
    private ProvisioningProfileApi provisioningProfileApi;
    private MetatraderAccountApi metatraderAccountApi;
    private ConnectionRegistry connectionRegistry;
    private MetatraderDemoAccountApi metatraderDemoAccountApi;

    public MetaApi(String token) throws ValidationException {
        this(token, null, null, null, null);
    }

    public MetaApi(String token, String application) throws ValidationException {
        this(token, application, null, null, null);
    }

    public MetaApi(String token, String application, String domain) throws ValidationException {
        this(token, application, domain, null, null);
    }

    public MetaApi(String token, String application, String domain, Integer requestTimeout, Integer connectTimeout) throws ValidationException {
        if (application == null) {
            application = "MetaApi";
        } else if (!application.matches("[a-zA-Z0-9_]+")) {
            ArrayList<ValidationDetails> details = new ArrayList<ValidationDetails>();
            throw new ValidationException("Application name must be non-empty string consisting from letters, digits and _ only", details);
        }
        if (domain == null) {
            domain = "agiliumtrade.agiliumtrade.ai";
        }
        if (requestTimeout == null) {
            requestTimeout = 60;
        }
        if (connectTimeout == null) {
            connectTimeout = 60;
        }
        HttpClient httpClient = new HttpClient(requestTimeout * 1000, connectTimeout * 1000);
        this.metaApiWebsocketClient = new MetaApiWebsocketClient(token, application, domain, (long)requestTimeout.intValue() * 1000L, (long)connectTimeout.intValue() * 1000L);
        this.provisioningProfileApi = new ProvisioningProfileApi(new ProvisioningProfileClient(httpClient, token, domain));
        this.connectionRegistry = new ConnectionRegistry(this.metaApiWebsocketClient, application);
        this.metatraderAccountApi = new MetatraderAccountApi(new MetatraderAccountClient(httpClient, token, domain), this.metaApiWebsocketClient, this.connectionRegistry);
        this.metatraderDemoAccountApi = new MetatraderDemoAccountApi(new MetatraderDemoAccountClient(httpClient, token, domain));
    }

    public ProvisioningProfileApi getProvisioningProfileApi() {
        return this.provisioningProfileApi;
    }

    public MetatraderAccountApi getMetatraderAccountApi() {
        return this.metatraderAccountApi;
    }

    public MetatraderDemoAccountApi getMetatraderDemoAccountApi() {
        return this.metatraderDemoAccountApi;
    }

    public void close() {
        this.metaApiWebsocketClient.close();
    }
}

