/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.error_handler.InternalException;
import cloud.metaapi.sdk.clients.error_handler.NotFoundException;
import cloud.metaapi.sdk.clients.error_handler.UnauthorizedException;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.meta_api.NotConnectedException;
import cloud.metaapi.sdk.clients.meta_api.NotSynchronizedException;
import cloud.metaapi.sdk.clients.meta_api.OutOfOrderListener;
import cloud.metaapi.sdk.clients.meta_api.PacketOrderer;
import cloud.metaapi.sdk.clients.meta_api.ReconnectListener;
import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.TradeException;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountInformation;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeal;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeals;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderHistoryOrders;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderPosition;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolPrice;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolSpecification;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTrade;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTradeResponse;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.clients.models.WebsocketError;
import cloud.metaapi.sdk.util.JsonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.engineio.client.Transport;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class MetaApiWebsocketClient
implements OutOfOrderListener {
    private static Logger logger = Logger.getLogger(MetaApiWebsocketClient.class);
    private String url;
    private String token;
    private Socket socket;
    private String application;
    private long requestTimeout;
    private long connectTimeout;
    private ObjectMapper jsonMapper = JsonMapper.getInstance();
    private Map<String, CompletableFuture<JsonNode>> requestResolves;
    private Map<String, List<SynchronizationListener>> synchronizationListeners;
    private List<ReconnectListener> reconnectListeners;
    private CompletableFuture<Void> connectFuture = null;
    private PacketOrderer packetOrderer;
    private boolean isSocketConnecting = false;
    private boolean connected = false;

    public MetaApiWebsocketClient(String token) {
        this(token, null, null, null, null);
    }

    public MetaApiWebsocketClient(String token, String application) {
        this(token, application, null, null, null);
    }

    public MetaApiWebsocketClient(String token, String application, String domain, Long requestTimeout, Long connectTimeout) {
        this.application = application != null ? application : "MetaApi";
        this.url = "https://mt-client-api-v1." + (domain != null ? domain : "agiliumtrade.agiliumtrade.ai");
        this.token = token;
        this.requestResolves = new HashMap<String, CompletableFuture<JsonNode>>();
        this.synchronizationListeners = new HashMap<String, List<SynchronizationListener>>();
        this.reconnectListeners = new LinkedList<ReconnectListener>();
        this.requestTimeout = requestTimeout != null ? requestTimeout : 60000L;
        this.connectTimeout = connectTimeout != null ? connectTimeout : 60000L;
        this.packetOrderer = new PacketOrderer(this, null);
    }

    @Override
    public void onOutOfOrderPacket(String accountId, long expectedSequenceNumber, long actualSequenceNumber, JsonNode packet, IsoTime receivedAt) {
        logger.error((Object)("MetaApi websocket client received an out of order packet type " + packet.get("type").asText() + " for account id " + accountId + ". Expected s/n " + expectedSequenceNumber + " does not match the actual of " + actualSequenceNumber));
        this.subscribe(accountId);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CompletableFuture<Void> connect() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.connected) {
                return null;
            }
            this.connected = true;
            this.requestResolves.clear();
            CompletableFuture result = new CompletableFuture();
            this.connectFuture = result;
            this.packetOrderer.start();
            String url = this.url + "?auth-token=" + this.token;
            IO.Options socketOptions = new IO.Options();
            socketOptions.path = "/ws";
            socketOptions.reconnection = true;
            socketOptions.reconnectionDelay = 1000L;
            socketOptions.reconnectionDelayMax = 5000L;
            socketOptions.reconnectionAttempts = Integer.MAX_VALUE;
            socketOptions.timeout = this.connectTimeout;
            socketOptions.transports = new String[]{"websocket"};
            this.isSocketConnecting = true;
            try {
                this.socket = IO.socket((String)url, (IO.Options)socketOptions);
                Random random = new Random();
                float clientId = random.nextFloat();
                this.socket.io().on("transport", socketEventArgs -> {
                    Transport transport = (Transport)socketEventArgs[0];
                    transport.on("requestHeaders", transportEventArgs -> {
                        Map headers = (Map)transportEventArgs[0];
                        headers.put("Client-id", Arrays.asList(String.valueOf(clientId)));
                    });
                });
                this.socket.on("connect", args -> {
                    this.isSocketConnecting = false;
                    CompletableFuture.runAsync(() -> {
                        logger.info((Object)"MetaApi websocket client connected to the MetaApi server");
                        if (!result.isDone()) {
                            result.complete(null);
                        } else {
                            ((CompletableFuture)this.fireReconnected().exceptionally(e -> {
                                logger.error((Object)"Failed to notify reconnect listeners", e);
                                return null;
                            })).join();
                        }
                        if (!this.connected) {
                            this.socket.close();
                        }
                    });
                });
                this.socket.on("reconnect", args -> {
                    try {
                        this.fireReconnected();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to notify reconnect listeners", (Throwable)e);
                    }
                });
                this.socket.on("connect_error", args -> {
                    Exception error = (Exception)args[0];
                    logger.error((Object)"MetaApi websocket client connection error", (Throwable)error);
                    if (!result.isDone()) {
                        result.completeExceptionally(error);
                    }
                });
                this.socket.on("connect_timeout", args -> {
                    logger.info((Object)"MetaApi websocket client connection timeout");
                    if (!result.isDone()) {
                        result.completeExceptionally(new TimeoutException("MetaApi websocket client connection timed out"));
                    }
                });
                this.socket.on("disconnect", args -> {
                    String reason = (String)args[0];
                    logger.info((Object)("MetaApi websocket client disconnected from the MetaApi server because of " + reason));
                    try {
                        this.reconnect();
                    }
                    catch (Exception e) {
                        logger.error((Object)"MetaApi websocket reconnect error", (Throwable)e);
                    }
                });
                this.socket.on("error", args -> {
                    Exception error = (Exception)args[0];
                    logger.error((Object)"MetaApi websocket client error", (Throwable)error);
                    try {
                        this.reconnect();
                    }
                    catch (Exception e) {
                        logger.error((Object)"MetaApi websocket reconnect error ", (Throwable)e);
                    }
                });
                this.socket.on("response", args -> {
                    try {
                        JsonNode data = this.jsonMapper.readTree(args[0].toString());
                        CompletableFuture<JsonNode> requestResolve = this.requestResolves.remove(data.get("requestId").asText());
                        if (requestResolve != null) {
                            requestResolve.complete(data);
                        }
                    }
                    catch (JsonProcessingException e) {
                        logger.error((Object)"MetaApi websocket parse json response error", (Throwable)e);
                    }
                });
                this.socket.on("processingError", args -> {
                    try {
                        WebsocketError error = (WebsocketError)this.jsonMapper.readValue(args[0].toString(), WebsocketError.class);
                        CompletableFuture<JsonNode> requestResolve = this.requestResolves.remove(error.requestId);
                        if (requestResolve != null) {
                            requestResolve.completeExceptionally(this.convertError(error));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"MetaApi websocket parse processingError data error", (Throwable)e);
                    }
                });
                this.socket.on("synchronization", args -> this.processSynchronizationPacket(args[0].toString()));
                this.socket.connect();
            }
            catch (URISyntaxException e) {
                result.completeExceptionally(e);
            }
            return (Void)result.join();
        });
    }

    public void close() {
        if (!this.connected) {
            return;
        }
        this.isSocketConnecting = false;
        this.connected = false;
        this.socket.close();
        this.requestResolves.values().forEach(resolve -> resolve.completeExceptionally(new Exception("MetaApi connection closed")));
        this.requestResolves.clear();
        this.synchronizationListeners.clear();
        this.packetOrderer.stop();
    }

    public CompletableFuture<MetatraderAccountInformation> getAccountInformation(String accountId) {
        CompletableFuture<MetatraderAccountInformation> result = new CompletableFuture<MetatraderAccountInformation>();
        ObjectNode request = JsonMapper.getInstance().createObjectNode();
        request.put("type", "getAccountInformation");
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete((MetatraderAccountInformation)this.jsonMapper.treeToValue((TreeNode)response.get("accountInformation"), MetatraderAccountInformation.class));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<List<MetatraderPosition>> getPositions(String accountId) {
        CompletableFuture<List<MetatraderPosition>> result = new CompletableFuture<List<MetatraderPosition>>();
        ObjectNode request = JsonMapper.getInstance().createObjectNode();
        request.put("type", "getPositions");
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete(Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("positions"), MetatraderPosition[].class)));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderPosition> getPosition(String accountId, String positionId) {
        ObjectNode request = JsonMapper.getInstance().createObjectNode();
        request.put("type", "getPosition");
        request.put("positionId", positionId);
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderPosition)this.jsonMapper.treeToValue((TreeNode)response.get("position"), MetatraderPosition.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<MetatraderOrder>> getOrders(String accountId) {
        CompletableFuture<List<MetatraderOrder>> result = new CompletableFuture<List<MetatraderOrder>>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getOrders");
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete(Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("orders"), MetatraderOrder[].class)));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderOrder> getOrder(String accountId, String orderId) {
        CompletableFuture<MetatraderOrder> result = new CompletableFuture<MetatraderOrder>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getOrder");
        request.put("orderId", orderId);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete((MetatraderOrder)this.jsonMapper.treeToValue((TreeNode)response.get("order"), MetatraderOrder.class));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTicket(String accountId, String ticket) {
        CompletableFuture<MetatraderHistoryOrders> result = new CompletableFuture<MetatraderHistoryOrders>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getHistoryOrdersByTicket");
        request.put("ticket", ticket);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderHistoryOrders history = new MetatraderHistoryOrders();
                history.historyOrders = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("historyOrders"), MetatraderOrder[].class));
                history.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(history);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByPosition(String accountId, String positionId) {
        CompletableFuture<MetatraderHistoryOrders> result = new CompletableFuture<MetatraderHistoryOrders>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getHistoryOrdersByPosition");
        request.put("positionId", positionId);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderHistoryOrders history = new MetatraderHistoryOrders();
                history.historyOrders = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("historyOrders"), MetatraderOrder[].class));
                history.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(history);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTimeRange(String accountId, IsoTime startTime, IsoTime endTime, int offset, int limit) {
        CompletableFuture<MetatraderHistoryOrders> result = new CompletableFuture<MetatraderHistoryOrders>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getHistoryOrdersByTimeRange");
        request.put("startTime", startTime.getIsoString());
        request.put("endTime", endTime.getIsoString());
        request.put("offset", offset);
        request.put("limit", limit);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderHistoryOrders history = new MetatraderHistoryOrders();
                history.historyOrders = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("historyOrders"), MetatraderOrder[].class));
                history.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(history);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderDeals> getDealsByTicket(String accountId, String ticket) {
        CompletableFuture<MetatraderDeals> result = new CompletableFuture<MetatraderDeals>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getDealsByTicket");
        request.put("ticket", ticket);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderDeals deals = new MetatraderDeals();
                deals.deals = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("deals"), MetatraderDeal[].class));
                deals.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(deals);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderDeals> getDealsByPosition(String accountId, String positionId) {
        CompletableFuture<MetatraderDeals> result = new CompletableFuture<MetatraderDeals>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getDealsByPosition");
        request.put("positionId", positionId);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderDeals deals = new MetatraderDeals();
                deals.deals = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("deals"), MetatraderDeal[].class));
                deals.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(deals);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderDeals> getDealsByTimeRange(String accountId, IsoTime startTime, IsoTime endTime, int offset, int limit) {
        CompletableFuture<MetatraderDeals> result = new CompletableFuture<MetatraderDeals>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getDealsByTimeRange");
        request.put("startTime", startTime.getIsoString());
        request.put("endTime", endTime.getIsoString());
        request.put("offset", offset);
        request.put("limit", limit);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderDeals deals = new MetatraderDeals();
                deals.deals = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("deals"), MetatraderDeal[].class));
                deals.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(deals);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> removeHistory(String accountId) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "removeHistory");
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<Void> removeApplication(String accountId) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "removeApplication");
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<MetatraderTradeResponse> trade(String accountId, MetatraderTrade trade) {
        return CompletableFuture.supplyAsync(() -> {
            ObjectNode request = this.jsonMapper.createObjectNode();
            request.put("type", "trade");
            request.set("trade", this.jsonMapper.valueToTree((Object)trade));
            return (MetatraderTradeResponse)((CompletableFuture)this.rpcRequest(accountId, request).thenApply(response -> {
                try {
                    MetatraderTradeResponse tradeResponse = (MetatraderTradeResponse)this.jsonMapper.treeToValue((TreeNode)response.get("response"), MetatraderTradeResponse.class);
                    if (Arrays.asList("ERR_NO_ERROR", "TRADE_RETCODE_PLACED", "TRADE_RETCODE_DONE", "TRADE_RETCODE_DONE_PARTIAL", "TRADE_RETCODE_NO_CHANGES").contains(tradeResponse.stringCode)) {
                        return tradeResponse;
                    }
                    throw new TradeException(tradeResponse.message, tradeResponse.numericCode, tradeResponse.stringCode);
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            })).join();
        });
    }

    public CompletableFuture<Void> subscribe(String accountId) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "subscribe");
        return ((CompletableFuture)this.rpcRequest(accountId, request).exceptionally(exception -> {
            logger.error((Object)"MetaApi websocket client failed to receive subscribe response", exception);
            throw new CompletionException((Throwable)exception);
        })).thenApply(response -> null);
    }

    public CompletableFuture<Void> reconnect(String accountId) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "reconnect");
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<Void> synchronize(String accountId, String synchronizationId, IsoTime startingHistoryOrderTime, IsoTime startingDealTime) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("requestId", synchronizationId);
        request.put("type", "synchronize");
        if (startingHistoryOrderTime != null) {
            request.put("startingHistoryOrderTime", startingHistoryOrderTime.getIsoString());
        }
        if (startingDealTime != null) {
            request.put("startingDealTime", startingDealTime.getIsoString());
        }
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<Void> waitSynchronized(String accountId, String applicationPattern, Long timeoutInSeconds) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "waitSynchronized");
        if (applicationPattern != null) {
            request.put("applicationPattern", applicationPattern);
        }
        request.put("timeoutInSeconds", timeoutInSeconds);
        return this.rpcRequest(accountId, request, timeoutInSeconds).thenApply(response -> null);
    }

    public CompletableFuture<Void> subscribeToMarketData(String accountId, String symbol) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "subscribeToMarketData");
        request.put("symbol", symbol);
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<MetatraderSymbolSpecification> getSymbolSpecification(String accountId, String symbol) {
        CompletableFuture<MetatraderSymbolSpecification> result = new CompletableFuture<MetatraderSymbolSpecification>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getSymbolSpecification");
        request.put("symbol", symbol);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete((MetatraderSymbolSpecification)this.jsonMapper.treeToValue((TreeNode)response.get("specification"), MetatraderSymbolSpecification.class));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderSymbolPrice> getSymbolPrice(String accountId, String symbol) {
        CompletableFuture<MetatraderSymbolPrice> result = new CompletableFuture<MetatraderSymbolPrice>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "getSymbolPrice");
        request.put("symbol", symbol);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete((MetatraderSymbolPrice)this.jsonMapper.treeToValue((TreeNode)response.get("price"), MetatraderSymbolPrice.class));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public void addSynchronizationListener(String accountId, SynchronizationListener listener) {
        List<SynchronizationListener> listeners = this.synchronizationListeners.get(accountId);
        if (listeners == null) {
            listeners = new LinkedList<SynchronizationListener>();
            this.synchronizationListeners.put(accountId, listeners);
        }
        listeners.add(listener);
    }

    public void removeSynchronizationListener(String accountId, SynchronizationListener listener) {
        List<SynchronizationListener> listeners = this.synchronizationListeners.get(accountId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void addReconnectListener(ReconnectListener listener) {
        this.reconnectListeners.add(listener);
    }

    public void removeReconnectListener(ReconnectListener listener) {
        this.reconnectListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.synchronizationListeners.clear();
        this.reconnectListeners.clear();
    }

    private CompletableFuture<Void> reconnect() throws InterruptedException, ExecutionException {
        return CompletableFuture.runAsync(() -> {
            while (!this.socket.connected() && !this.isSocketConnecting && this.connected) {
                this.tryReconnect();
            }
        });
    }

    private void tryReconnect() {
        try {
            Thread.sleep(1000L);
            if (!this.socket.connected() && !this.isSocketConnecting && this.connected) {
                this.isSocketConnecting = true;
                this.socket.connect();
            }
        }
        catch (InterruptedException e) {
            throw new CompletionException(e);
        }
    }

    private CompletableFuture<JsonNode> rpcRequest(String accountId, ObjectNode request) {
        return this.rpcRequest(accountId, request, null);
    }

    private CompletableFuture<JsonNode> rpcRequest(String accountId, ObjectNode request, Long timeoutInSeconds) {
        String requestId = request.has("requestId") ? request.get("requestId").asText() : UUID.randomUUID().toString();
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (!this.connected) {
                    this.connect().join();
                } else {
                    this.connectFuture.join();
                }
                CompletableFuture result = new CompletableFuture();
                this.requestResolves.put(requestId, result);
                request.put("accountId", accountId);
                request.put("application", this.application);
                if (!request.has("requestId")) {
                    request.put("requestId", requestId);
                }
                this.socket.emit("request", new Object[]{new JSONObject(this.jsonMapper.writeValueAsString((Object)request))});
                if (timeoutInSeconds != null) {
                    return (JsonNode)result.get(timeoutInSeconds, TimeUnit.SECONDS);
                }
                return (JsonNode)result.get(this.requestTimeout, TimeUnit.MILLISECONDS);
            }
            catch (java.util.concurrent.TimeoutException e) {
                throw new CompletionException(new TimeoutException("MetaApi websocket client request " + requestId + " of type " + request.get("type").asText() + " timed out. Please make sure your account is connected to broker before retrying your request."));
            }
            catch (JsonProcessingException | InterruptedException | JSONException e) {
                throw new CompletionException(e);
            }
            catch (ExecutionException e) {
                throw new CompletionException(e.getCause());
            }
        });
    }

    private Exception convertError(WebsocketError error) {
        switch (error.error) {
            case "ValidationError": {
                return new ValidationException(error.message, error.details);
            }
            case "NotFoundError": {
                return new NotFoundException(error.message);
            }
            case "NotSynchronizedError": {
                return new NotSynchronizedException(error.message);
            }
            case "TimeoutError": {
                return new TimeoutException(error.message);
            }
            case "NotAuthenticatedError": {
                return new NotConnectedException(error.message);
            }
            case "TradeError": {
                return new TradeException(error.message, error.numericCode, error.stringCode);
            }
            case "UnauthorizedError": {
                this.close();
                return new UnauthorizedException(error.message);
            }
        }
        return new InternalException(error.message);
    }

    private CompletableFuture<Void> processSynchronizationPacket(String jsonPacket) {
        return CompletableFuture.runAsync(() -> {
            try {
                List<JsonNode> packets = this.packetOrderer.restoreOrder(this.jsonMapper.readTree(jsonPacket));
                for (JsonNode data : packets) {
                    MetatraderOrder[] historyOrders;
                    ArrayList<CompletionStage> completableFutures;
                    MetatraderDeal[] deals;
                    MetatraderAccountInformation accountInformation;
                    ArrayList<CompletionStage> completableFutures2;
                    String accountId = data.get("accountId").asText();
                    List<SynchronizationListener> listeners = this.synchronizationListeners.get(accountId);
                    if (listeners == null || listeners.isEmpty()) {
                        return;
                    }
                    String type = data.get("type").asText();
                    if (type.equals("authenticated")) {
                        ArrayList<CompletionStage> completableFutures3 = new ArrayList<CompletionStage>();
                        for (SynchronizationListener listener2 : listeners) {
                            completableFutures3.add(listener2.onConnected().exceptionally(e -> {
                                logger.error((Object)"Failed to notify listener about connected event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures3.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("disconnected")) {
                        completableFutures2 = new ArrayList<CompletionStage>();
                        for (SynchronizationListener listener3 : listeners) {
                            completableFutures2.add(listener3.onDisconnected().exceptionally(e -> {
                                logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("synchronizationStarted")) {
                        completableFutures2 = new ArrayList();
                        for (SynchronizationListener listener4 : listeners) {
                            completableFutures2.add(listener4.onSynchronizationStarted().exceptionally(e -> {
                                logger.error((Object)(accountId + ": Failed to notify listener about synchronization started event"), e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("accountInformation")) {
                        if (!data.hasNonNull(type)) continue;
                        accountInformation = (MetatraderAccountInformation)this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderAccountInformation.class);
                        MetatraderDeal[] completableFutures22 = new ArrayList();
                        for (SynchronizationListener listener5 : listeners) {
                            completableFutures22.add(listener5.onAccountInformationUpdated(accountInformation).exceptionally(e -> {
                                logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures22.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("deals")) {
                        if (!data.hasNonNull(type)) continue;
                        for (MetatraderDeal metatraderDeal : deals = (MetatraderDeal[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderDeal[].class)) {
                            completableFutures = new ArrayList<CompletionStage>();
                            for (SynchronizationListener listener6 : listeners) {
                                completableFutures.add(listener6.onDealAdded(metatraderDeal).exceptionally(e -> {
                                    logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                        continue;
                    }
                    if (type.equals("orders")) {
                        completableFutures2 = new ArrayList();
                        MetatraderOrder[] orders = data.hasNonNull("orders") ? (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderOrder[].class) : new MetatraderOrder[]{};
                        for (SynchronizationListener listener7 : listeners) {
                            completableFutures2.add(listener7.onOrdersReplaced(Arrays.asList(orders)).exceptionally(e -> {
                                logger.error((Object)"Failed to notify listener about orders event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("historyOrders")) {
                        if (!data.hasNonNull(type)) continue;
                        historyOrders = (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderOrder[].class);
                        for (MetatraderOrder metatraderOrder : historyOrders) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onHistoryOrderAdded(metatraderOrder).exceptionally(e -> {
                                    logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                        continue;
                    }
                    if (type.equals("positions")) {
                        completableFutures2 = new ArrayList();
                        MetatraderPosition[] positions = data.hasNonNull("positions") ? (MetatraderPosition[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderPosition[].class) : new MetatraderPosition[]{};
                        for (SynchronizationListener listener8 : listeners) {
                            completableFutures2.add(listener8.onPositionsReplaced(Arrays.asList(positions)).exceptionally(e -> {
                                logger.error((Object)"Failed to notify listener about positions event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("update")) {
                        if (data.hasNonNull("accountInformation")) {
                            accountInformation = (MetatraderAccountInformation)this.jsonMapper.treeToValue((TreeNode)data.get("accountInformation"), MetatraderAccountInformation.class);
                            ArrayList<CompletionStage> completableFutures3 = new ArrayList<CompletionStage>();
                            for (SynchronizationListener listener9 : listeners) {
                                completableFutures3.add(listener9.onAccountInformationUpdated(accountInformation).exceptionally(e -> {
                                    logger.error((Object)"Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures3.toArray(new CompletableFuture[0])).get();
                        }
                        if (data.hasNonNull("updatedPositions")) {
                            MetatraderPosition[] positions = (MetatraderPosition[])this.jsonMapper.treeToValue((TreeNode)data.get("updatedPositions"), MetatraderPosition[].class);
                            for (MetatraderPosition metatraderPosition : positions) {
                                completableFutures = new ArrayList();
                                for (SynchronizationListener listener : listeners) {
                                    completableFutures.add(listener.onPositionUpdated(metatraderPosition).exceptionally(e -> {
                                        logger.error((Object)"Failed to notify listener about update event", e);
                                        return null;
                                    }));
                                }
                                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                            }
                        }
                        if (data.hasNonNull("removedPositionIds")) {
                            String[] removedPositionIds = (String[])this.jsonMapper.treeToValue((TreeNode)data.get("removedPositionIds"), String[].class);
                            for (String string : removedPositionIds) {
                                completableFutures = new ArrayList();
                                for (SynchronizationListener listener : listeners) {
                                    completableFutures.add(listener.onPositionRemoved(string).exceptionally(e -> {
                                        logger.error((Object)"Failed to notify listener about update event", e);
                                        return null;
                                    }));
                                }
                                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                            }
                        }
                        if (data.hasNonNull("updatedOrders")) {
                            MetatraderOrder[] updatedOrders = (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get("updatedOrders"), MetatraderOrder[].class);
                            for (MetatraderOrder metatraderOrder : updatedOrders) {
                                completableFutures = new ArrayList();
                                for (SynchronizationListener listener : listeners) {
                                    completableFutures.add(listener.onOrderUpdated(metatraderOrder).exceptionally(e -> {
                                        logger.error((Object)"Failed to notify listener about update event", e);
                                        return null;
                                    }));
                                }
                                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                            }
                        }
                        if (data.hasNonNull("completedOrderIds")) {
                            String[] completedOrderIds = (String[])this.jsonMapper.treeToValue((TreeNode)data.get("completedOrderIds"), String[].class);
                            for (String string : completedOrderIds) {
                                completableFutures = new ArrayList();
                                for (SynchronizationListener listener : listeners) {
                                    completableFutures.add(listener.onOrderCompleted(string).exceptionally(e -> {
                                        logger.error((Object)"Failed to notify listener about update event", e);
                                        return null;
                                    }));
                                }
                                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                            }
                        }
                        if (data.hasNonNull("historyOrders")) {
                            historyOrders = (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get("historyOrders"), MetatraderOrder[].class);
                            for (MetatraderOrder metatraderOrder : historyOrders) {
                                completableFutures = new ArrayList();
                                for (SynchronizationListener listener : listeners) {
                                    completableFutures.add(listener.onHistoryOrderAdded(metatraderOrder).exceptionally(e -> {
                                        logger.error((Object)"Failed to notify listener about update event", e);
                                        return null;
                                    }));
                                }
                                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                            }
                        }
                        if (!data.hasNonNull("deals")) continue;
                        deals = (MetatraderDeal[])this.jsonMapper.treeToValue((TreeNode)data.get("deals"), MetatraderDeal[].class);
                        for (MetatraderDeal metatraderDeal : deals) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onDealAdded(metatraderDeal).exceptionally(e -> {
                                    logger.error((Object)"Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                        continue;
                    }
                    if (type.equals("dealSynchronizationFinished")) {
                        completableFutures2 = new ArrayList();
                        for (SynchronizationListener listener10 : listeners) {
                            completableFutures2.add(listener10.onDealSynchronizationFinished(data.get("synchronizationId").asText()).exceptionally(e -> {
                                logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("orderSynchronizationFinished")) {
                        completableFutures2 = new ArrayList();
                        for (SynchronizationListener listener11 : listeners) {
                            completableFutures2.add(listener11.onOrderSynchronizationFinished(data.get("synchronizationId").asText()).exceptionally(e -> {
                                logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("status")) {
                        completableFutures2 = new ArrayList();
                        for (SynchronizationListener listener12 : listeners) {
                            completableFutures2.add(listener12.onBrokerConnectionStatusChanged(data.get("connected").asBoolean()).exceptionally(e -> {
                                logger.error((Object)"Failed to notify listener about brokerConnectionStatusChanged event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                        continue;
                    }
                    if (type.equals("specifications")) {
                        if (!data.hasNonNull(type)) continue;
                        MetatraderSymbolSpecification[] specifications = (MetatraderSymbolSpecification[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderSymbolSpecification[].class);
                        for (MetatraderSymbolSpecification metatraderSymbolSpecification : specifications) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onSymbolSpecificationUpdated(metatraderSymbolSpecification).exceptionally(e -> {
                                    logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                        continue;
                    }
                    if (!type.equals("prices") || !data.hasNonNull(type)) continue;
                    MetatraderSymbolPrice[] prices = (MetatraderSymbolPrice[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderSymbolPrice[].class);
                    for (MetatraderSymbolPrice metatraderSymbolPrice : prices) {
                        completableFutures = new ArrayList();
                        for (SynchronizationListener listener : listeners) {
                            completableFutures.add(listener.onSymbolPriceUpdated(metatraderSymbolPrice).exceptionally(e -> {
                                logger.error((Object)("Failed to notify listener about " + type + " event"), e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                    }
                }
            }
            catch (JsonProcessingException | InterruptedException | ExecutionException e2) {
                logger.error((Object)"Failed to process incoming synchronization packet", e2);
            }
        });
    }

    private CompletableFuture<Void> fireReconnected() {
        return CompletableFuture.runAsync(() -> {
            this.reconnectListeners.forEach(action -> {});
            for (ReconnectListener listener : this.reconnectListeners) {
                listener.onReconnected().join();
            }
        });
    }
}

