/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.models;

import cloud.metaapi.sdk.clients.models.IsoTimeJsonDeserializer;
import cloud.metaapi.sdk.clients.models.IsoTimeJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

@JsonSerialize(using=IsoTimeJsonSerializer.class)
@JsonDeserialize(using=IsoTimeJsonDeserializer.class)
public class IsoTime {
    private Date date;

    public IsoTime(String isoTime) {
        this.setTime(isoTime);
    }

    public IsoTime(Date date) {
        this.setTime(date);
    }

    public void setTime(String isoTime) {
        this.date = Date.from(ZonedDateTime.parse(isoTime).toInstant());
    }

    public void setTime(Date date) {
        this.date = date;
    }

    public String getIsoString() {
        return ZonedDateTime.ofInstant(this.date.toInstant(), ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }

    public Date getDate() {
        return this.date;
    }

    public String toString() {
        return this.getIsoString();
    }
}

