/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountInformation;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderPosition;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolPrice;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;

public class TerminalState
extends SynchronizationListener {
    protected int statusTimerTimeoutInMilliseconds = 60000;
    private boolean connected = false;
    private boolean connectedToBroker = false;
    private List<MetatraderPosition> positions = new ArrayList<MetatraderPosition>();
    private List<MetatraderOrder> orders = new ArrayList<MetatraderOrder>();
    private List<MetatraderSymbolSpecification> specifications = new ArrayList<MetatraderSymbolSpecification>();
    private Map<String, MetatraderSymbolSpecification> specificationsBySymbol = new HashMap<String, MetatraderSymbolSpecification>();
    private Map<String, MetatraderSymbolPrice> pricesBySymbol = new HashMap<String, MetatraderSymbolPrice>();
    private Optional<MetatraderAccountInformation> accountInformation = Optional.empty();
    private Timer statusTimer = null;

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isConnectedToBroker() {
        return this.connectedToBroker;
    }

    public Optional<MetatraderAccountInformation> getAccountInformation() {
        return this.accountInformation;
    }

    public List<MetatraderPosition> getPositions() {
        return this.positions;
    }

    public List<MetatraderOrder> getOrders() {
        return this.orders;
    }

    public List<MetatraderSymbolSpecification> getSpecifications() {
        return this.specifications;
    }

    public Optional<MetatraderSymbolSpecification> getSpecification(String symbol) {
        return Optional.ofNullable(this.specificationsBySymbol.get(symbol));
    }

    public Optional<MetatraderSymbolPrice> getPrice(String symbol) {
        return Optional.ofNullable(this.pricesBySymbol.get(symbol));
    }

    @Override
    public CompletableFuture<Void> onConnected() {
        this.connected = true;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDisconnected() {
        this.connected = false;
        this.connectedToBroker = false;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onBrokerConnectionStatusChanged(boolean connected) {
        this.connectedToBroker = connected;
        if (this.statusTimer != null) {
            this.statusTimer.cancel();
        }
        final TerminalState self = this;
        this.statusTimer = new Timer();
        this.statusTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                self.onDisconnected();
            }
        }, this.statusTimerTimeoutInMilliseconds);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onAccountInformationUpdated(MetatraderAccountInformation accountInformation) {
        this.accountInformation = Optional.of(accountInformation);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onPositionUpdated(MetatraderPosition position) {
        for (int i = 0; i < this.positions.size(); ++i) {
            if (!this.positions.get((int)i).id.equals(position.id)) continue;
            this.positions.set(i, position);
            return CompletableFuture.completedFuture(null);
        }
        this.positions.add(position);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onPositionRemoved(String positionId) {
        this.positions.removeIf(position -> position.id.equals(positionId));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrderUpdated(MetatraderOrder order) {
        for (int i = 0; i < this.orders.size(); ++i) {
            if (!this.orders.get((int)i).id.equals(order.id)) continue;
            this.orders.set(i, order);
            return CompletableFuture.completedFuture(null);
        }
        this.orders.add(order);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrderCompleted(String orderId) {
        this.orders.removeIf(order -> order.id.equals(orderId));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onSymbolSpecificationUpdated(MetatraderSymbolSpecification specification) {
        int index = -1;
        for (int i = 0; i < this.specifications.size(); ++i) {
            if (!this.specifications.get((int)i).symbol.equals(specification.symbol)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.specifications.set(index, specification);
        } else {
            this.specifications.add(specification);
        }
        this.specificationsBySymbol.put(specification.symbol, specification);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onSymbolPriceUpdated(MetatraderSymbolPrice price) {
        this.pricesBySymbol.put(price.symbol, price);
        Optional<MetatraderSymbolSpecification> specification = this.getSpecification(price.symbol);
        if (specification.isPresent()) {
            for (MetatraderPosition position : this.positions) {
                if (!position.symbol.equals(price.symbol)) continue;
                if (position.unrealizedProfit == null || position.realizedProfit == null) {
                    position.unrealizedProfit = (double)(position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? 1 : -1) * (position.currentPrice - position.openPrice) * position.currentTickValue * position.volume / specification.get().tickSize;
                    position.realizedProfit = position.profit - position.unrealizedProfit;
                }
                double newPositionPrice = position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? price.bid : price.ask;
                double isProfitable = (double)(position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? 1 : -1) * (newPositionPrice - position.openPrice);
                double currentTickValue = isProfitable > 0.0 ? price.profitTickValue : price.lossTickValue;
                double unrealizedProfit = (double)(position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? 1 : -1) * (newPositionPrice - position.openPrice) * currentTickValue * position.volume / specification.get().tickSize;
                position.unrealizedProfit = unrealizedProfit;
                position.profit = position.unrealizedProfit + position.realizedProfit;
                position.currentPrice = newPositionPrice;
                position.currentTickValue = currentTickValue;
            }
            for (MetatraderOrder order : this.orders) {
                if (!order.symbol.equals(price.symbol)) continue;
                order.currentPrice = order.type == MetatraderOrder.OrderType.ORDER_TYPE_BUY_LIMIT || order.type == MetatraderOrder.OrderType.ORDER_TYPE_BUY_STOP || order.type == MetatraderOrder.OrderType.ORDER_TYPE_BUY_STOP_LIMIT ? price.ask : price.bid;
            }
            if (this.accountInformation.isPresent()) {
                double profitSum = 0.0;
                for (MetatraderPosition position : this.positions) {
                    profitSum += position.profit;
                }
                this.accountInformation.get().equity = this.accountInformation.get().balance + profitSum;
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

