/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.meta_api.OutOfOrderListener;
import cloud.metaapi.sdk.clients.models.IsoTime;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;

public class PacketOrderer {
    private OutOfOrderListener outOfOrderListener;
    private int orderingTimeoutInSeconds;
    private Map<String, Boolean> isOutOfOrderEmitted;
    private Map<String, AtomicLong> sequenceNumberByAccount;
    private Map<String, Integer> lastSessionStartTimestamp;
    private Map<String, List<Packet>> packetsByAccountId;
    private int waitListSizeLimit = 100;
    private Timer outOfOrderJob;

    public PacketOrderer(OutOfOrderListener outOfOrderListener, Integer orderingTimeoutInSeconds) {
        this.outOfOrderListener = outOfOrderListener;
        this.orderingTimeoutInSeconds = orderingTimeoutInSeconds != null ? orderingTimeoutInSeconds : 10;
        this.isOutOfOrderEmitted = new HashMap<String, Boolean>();
    }

    public void start() {
        final PacketOrderer self = this;
        this.sequenceNumberByAccount = new HashMap<String, AtomicLong>();
        this.lastSessionStartTimestamp = new HashMap<String, Integer>();
        this.packetsByAccountId = new HashMap<String, List<Packet>>();
        this.outOfOrderJob = new Timer();
        this.outOfOrderJob.schedule(new TimerTask(){

            @Override
            public void run() {
                self.emitOutOfOrderEvents();
            }
        }, 1000L, 1000L);
    }

    public void stop() {
        if (this.outOfOrderJob != null) {
            this.outOfOrderJob.cancel();
            this.outOfOrderJob = null;
        }
    }

    public List<JsonNode> restoreOrder(JsonNode packet) {
        long sequenceNumber;
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        long l = sequenceNumber = packet.has("sequenceNumber") ? packet.get("sequenceNumber").asLong() : -1L;
        if (sequenceNumber == -1L) {
            result.add(packet);
            return result;
        }
        String accountId = packet.get("accountId").asText();
        if (packet.get("type").asText().equals("specifications") && packet.has("synchronizationId")) {
            this.isOutOfOrderEmitted.put(accountId, false);
            this.sequenceNumberByAccount.put(accountId, new AtomicLong(sequenceNumber));
            this.lastSessionStartTimestamp.put(accountId, packet.get("sequenceTimestamp").asInt());
            if (this.packetsByAccountId.containsKey(accountId)) {
                this.packetsByAccountId.get(accountId).removeIf(waitPacket -> waitPacket.packet.get("sequenceTimestamp").asInt() < packet.get("sequenceTimestamp").asInt());
            }
            result.add(packet);
            result.addAll(this.findNextPacketsFromWaitList(accountId));
            return result;
        }
        if (this.lastSessionStartTimestamp.containsKey(accountId) && packet.get("sequenceTimestamp").asInt() < this.lastSessionStartTimestamp.get(accountId)) {
            return result;
        }
        if (this.sequenceNumberByAccount.containsKey(accountId) && sequenceNumber == this.sequenceNumberByAccount.get(accountId).get()) {
            result.add(packet);
            return result;
        }
        if (this.sequenceNumberByAccount.containsKey(accountId) && sequenceNumber == this.sequenceNumberByAccount.get(accountId).get() + 1L) {
            this.sequenceNumberByAccount.get(accountId).incrementAndGet();
            result.add(packet);
            result.addAll(this.findNextPacketsFromWaitList(accountId));
            return result;
        }
        if (this.packetsByAccountId.get(accountId) == null) {
            this.packetsByAccountId.put(accountId, new ArrayList());
        }
        List<Packet> waitList = this.packetsByAccountId.get(accountId);
        Packet p = new Packet();
        p.accountId = accountId;
        p.sequenceNumber = sequenceNumber;
        p.packet = packet;
        p.receivedAt = new IsoTime(Date.from(Instant.now()));
        waitList.add(p);
        waitList.sort((e1, e2) -> e1.sequenceNumber - e2.sequenceNumber > 0L ? 1 : -1);
        while (waitList.size() > this.waitListSizeLimit) {
            waitList.remove(0);
        }
        return result;
    }

    private List<JsonNode> findNextPacketsFromWaitList(String accountId) {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        List waitList = this.packetsByAccountId.getOrDefault(accountId, new ArrayList());
        while (!(waitList.isEmpty() || ((Packet)waitList.get((int)0)).sequenceNumber != this.sequenceNumberByAccount.get(accountId).get() && ((Packet)waitList.get((int)0)).sequenceNumber != this.sequenceNumberByAccount.get(accountId).get() + 1L)) {
            result.add(((Packet)waitList.get((int)0)).packet);
            if (((Packet)waitList.get((int)0)).sequenceNumber == this.sequenceNumberByAccount.get(accountId).get() + 1L) {
                this.sequenceNumberByAccount.get(accountId).getAndIncrement();
            }
            waitList.remove(0);
        }
        if (waitList.isEmpty()) {
            this.packetsByAccountId.remove(accountId);
        }
        return result;
    }

    private void emitOutOfOrderEvents() {
        this.packetsByAccountId.values().forEach(waitList -> {
            if (!waitList.isEmpty()) {
                String accountId;
                Packet packet = (Packet)waitList.get(0);
                if (packet == null) {
                    return;
                }
                Instant receivedAtPlusTimeout = packet.receivedAt.getDate().toInstant().plusSeconds(this.orderingTimeoutInSeconds);
                if (receivedAtPlusTimeout.compareTo(Instant.now()) < 0 && !this.isOutOfOrderEmitted.getOrDefault(accountId = packet.accountId, false).booleanValue()) {
                    this.isOutOfOrderEmitted.put(accountId, true);
                    this.outOfOrderListener.onOutOfOrderPacket(packet.accountId, this.sequenceNumberByAccount.getOrDefault(accountId, new AtomicLong(0L)).get() + 1L, packet.sequenceNumber, packet.packet, packet.receivedAt);
                }
            }
        });
    }

    protected class Packet {
        public String accountId;
        public long sequenceNumber;
        public JsonNode packet;
        public IsoTime receivedAt;

        protected Packet() {
        }
    }
}

