/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients;

import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.error_handler.ApiException;
import cloud.metaapi.sdk.clients.error_handler.ConflictException;
import cloud.metaapi.sdk.clients.error_handler.ForbiddenException;
import cloud.metaapi.sdk.clients.error_handler.InternalException;
import cloud.metaapi.sdk.clients.error_handler.NotFoundException;
import cloud.metaapi.sdk.clients.error_handler.UnauthorizedException;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.models.Error;
import cloud.metaapi.sdk.clients.models.ValidationDetails;
import cloud.metaapi.sdk.util.JsonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.MultipartBody;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;

public class HttpClient {
    private int requestTimeout;
    private int connectTimeout;

    public HttpClient() {
        this(60000, 60000);
    }

    public HttpClient(int requestTimeout, int connectTimeout) {
        this.requestTimeout = requestTimeout;
        this.connectTimeout = connectTimeout;
    }

    public CompletableFuture<String> request(HttpRequestOptions options) {
        return this.makeCheckedRequest(options).thenApply(response -> (String)response.getBody());
    }

    public <T> CompletableFuture<T> requestJson(HttpRequestOptions options, Class<T> valueType) {
        return this.request(options).thenApply(response -> {
            try {
                return JsonMapper.getInstance().readValue(response, valueType);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    protected CompletableFuture<HttpResponse<String>> makeCheckedRequest(HttpRequestOptions options) {
        return ((CompletableFuture)this.makeRequest(options).exceptionally(error -> {
            throw new CompletionException(new ApiException(error.getMessage(), 0, error.getCause()));
        })).thenApply(response -> {
            ApiException error = this.checkHttpError((HttpResponse<String>)response);
            if (error == null) {
                return response;
            }
            throw new CompletionException(error);
        });
    }

    private CompletableFuture<HttpResponse<String>> makeRequest(HttpRequestOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                GetRequest request = null;
                if (options.getMethod() == HttpRequestOptions.Method.GET) {
                    request = Unirest.get((String)options.getUrl());
                } else {
                    HttpRequestWithBody bodyRequest = null;
                    switch (options.getMethod()) {
                        case POST: {
                            bodyRequest = Unirest.post((String)options.getUrl());
                            break;
                        }
                        case PUT: {
                            bodyRequest = Unirest.put((String)options.getUrl());
                            break;
                        }
                        case DELETE: {
                            bodyRequest = Unirest.delete((String)options.getUrl());
                            break;
                        }
                    }
                    if (options.getBodyJson().isPresent()) {
                        String jsonString = JsonMapper.getInstance().writeValueAsString(options.getBodyJson().get());
                        request = bodyRequest.body(jsonString).header("content-type", "application/json");
                    } else if (options.getBodyFields().isPresent()) {
                        Map<String, Object> fields = options.getBodyFields().get();
                        if (fields.isEmpty()) {
                            request = bodyRequest;
                        } else {
                            MultipartBody multipartBody = bodyRequest.fields(null);
                            fields.forEach((name, value) -> {
                                if (value instanceof HttpRequestOptions.FileStreamField) {
                                    HttpRequestOptions.FileStreamField fileField = (HttpRequestOptions.FileStreamField)value;
                                    multipartBody.field(name, fileField.getStream(), fileField.getFileName());
                                } else {
                                    multipartBody.field(name, value.toString());
                                }
                            });
                            request = multipartBody;
                        }
                    } else {
                        request = bodyRequest;
                    }
                }
                GetRequest finalRequest = request;
                finalRequest.connectTimeout(this.connectTimeout);
                finalRequest.socketTimeout(this.requestTimeout);
                finalRequest.headers(options.getHeaders());
                options.getQueryParameters().forEach((arg_0, arg_1) -> HttpClient.lambda$null$5((HttpRequest)finalRequest, arg_0, arg_1));
                return finalRequest.asString();
            }
            catch (JsonProcessingException | UnirestException e) {
                throw new CompletionException(e);
            }
        });
    }

    private ApiException checkHttpError(HttpResponse<String> response) {
        Error error;
        int statusType = response.getStatus() / 100;
        if (statusType != 4 && statusType != 5) {
            return null;
        }
        try {
            error = (Error)JsonMapper.getInstance().readValue((String)response.getBody(), Error.class);
        }
        catch (JsonProcessingException e) {
            error = null;
        }
        switch (response.getStatus()) {
            case 400: {
                return new ValidationException(error != null ? error.message : response.getStatusText(), error != null ? error.details : new ArrayList<ValidationDetails>());
            }
            case 401: {
                return new UnauthorizedException(error != null ? error.message : response.getStatusText());
            }
            case 403: {
                return new ForbiddenException(error != null ? error.message : response.getStatusText());
            }
            case 404: {
                return new NotFoundException(error != null ? error.message : response.getStatusText());
            }
            case 409: {
                return new ConflictException(error != null ? error.message : response.getStatusText());
            }
            case 500: {
                return new InternalException(error != null ? error.message : response.getStatusText());
            }
        }
        return new ApiException(error != null ? error.message : response.getStatusText(), response.getStatus());
    }

    private static /* synthetic */ void lambda$null$5(HttpRequest finalRequest, String key, Object value) {
        if (value instanceof Collection) {
            finalRequest.queryString(key, (Collection)value);
        } else {
            finalRequest.queryString(key, value);
        }
    }
}

