/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.ReconnectListener;
import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.models.MarketTradeOptions;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountInformation;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeals;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderHistoryOrders;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderPosition;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolPrice;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolSpecification;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTrade;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTradeResponse;
import cloud.metaapi.sdk.clients.meta_api.models.PendingTradeOptions;
import cloud.metaapi.sdk.clients.meta_api.models.SynchronizationOptions;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.meta_api.MemoryHistoryStorage;
import cloud.metaapi.sdk.meta_api.MetatraderAccount;
import cloud.metaapi.sdk.meta_api.TerminalState;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.log4j.Logger;

public class MetaApiConnection
extends SynchronizationListener
implements ReconnectListener {
    private static Logger logger = Logger.getLogger(MetaApiConnection.class);
    private MetaApiWebsocketClient websocketClient;
    private MetatraderAccount account;
    private HashSet<String> ordersSynchronized = new HashSet();
    private HashSet<String> dealsSynchronized = new HashSet();
    private ConnectionRegistry connectionRegistry;
    private IsoTime historyStartTime = null;
    private String lastSynchronizationId = null;
    private String lastDisconnectedSynchronizationId = null;
    private TerminalState terminalState;
    private HistoryStorage historyStorage;
    private boolean closed = false;

    public MetaApiConnection(MetaApiWebsocketClient websocketClient, MetatraderAccount account, HistoryStorage historyStorage, ConnectionRegistry connectionRegistry) {
        this(websocketClient, account, historyStorage, connectionRegistry, null);
    }

    public MetaApiConnection(MetaApiWebsocketClient websocketClient, MetatraderAccount account, HistoryStorage historyStorage, ConnectionRegistry connectionRegistry, IsoTime historyStartTime) {
        this.websocketClient = websocketClient;
        this.account = account;
        this.connectionRegistry = connectionRegistry;
        this.historyStartTime = historyStartTime;
        this.terminalState = new TerminalState();
        this.historyStorage = historyStorage != null ? historyStorage : new MemoryHistoryStorage(account.getId(), connectionRegistry.getApplication());
        websocketClient.addSynchronizationListener(account.getId(), this);
        websocketClient.addSynchronizationListener(account.getId(), this.terminalState);
        websocketClient.addSynchronizationListener(account.getId(), this.historyStorage);
        websocketClient.addReconnectListener(this);
    }

    public CompletableFuture<MetatraderAccountInformation> getAccountInformation() {
        return this.websocketClient.getAccountInformation(this.account.getId());
    }

    public CompletableFuture<List<MetatraderPosition>> getPositions() {
        return this.websocketClient.getPositions(this.account.getId());
    }

    public CompletableFuture<MetatraderPosition> getPosition(String positionId) {
        return this.websocketClient.getPosition(this.account.getId(), positionId);
    }

    public CompletableFuture<List<MetatraderOrder>> getOrders() {
        return this.websocketClient.getOrders(this.account.getId());
    }

    public CompletableFuture<MetatraderOrder> getOrder(String orderId) {
        return this.websocketClient.getOrder(this.account.getId(), orderId);
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTicket(String ticket) {
        return this.websocketClient.getHistoryOrdersByTicket(this.account.getId(), ticket);
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByPosition(String positionId) {
        return this.websocketClient.getHistoryOrdersByPosition(this.account.getId(), positionId);
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTimeRange(IsoTime startTime, IsoTime endTime, int offset, int limit) {
        return this.websocketClient.getHistoryOrdersByTimeRange(this.account.getId(), startTime, endTime, offset, limit);
    }

    public CompletableFuture<MetatraderDeals> getDealsByTicket(String ticket) {
        return this.websocketClient.getDealsByTicket(this.account.getId(), ticket);
    }

    public CompletableFuture<MetatraderDeals> getDealsByPosition(String positionId) {
        return this.websocketClient.getDealsByPosition(this.account.getId(), positionId);
    }

    public CompletableFuture<MetatraderDeals> getDealsByTimeRange(IsoTime startTime, IsoTime endTime, int offset, int limit) {
        return this.websocketClient.getDealsByTimeRange(this.account.getId(), startTime, endTime, offset, limit);
    }

    public CompletableFuture<Void> removeHistory() {
        this.historyStorage.reset();
        return this.websocketClient.removeHistory(this.account.getId());
    }

    public CompletableFuture<Void> removeApplication() {
        this.historyStorage.reset();
        return this.websocketClient.removeApplication(this.account.getId());
    }

    public CompletableFuture<MetatraderTradeResponse> createMarketBuyOrder(String symbol, double volume, Double stopLoss, Double takeProfit, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_BUY;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createMarketSellOrder(String symbol, double volume, Double stopLoss, Double takeProfit, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_SELL;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createLimitBuyOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_BUY_LIMIT;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createLimitSellOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_SELL_LIMIT;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopBuyOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_BUY_STOP;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopSellOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_SELL_STOP;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> modifyPosition(String positionId, Double stopLoss, Double takeProfit) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITION_MODIFY;
        trade.positionId = positionId;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> closePositionPartially(String positionId, double volume, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITION_PARTIAL;
        trade.positionId = positionId;
        trade.volume = volume;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> closePosition(String positionId, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITION_CLOSE_ID;
        trade.positionId = positionId;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> closePositionsBySymbol(String symbol, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITIONS_CLOSE_SYMBOL;
        trade.symbol = symbol;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> modifyOrder(String orderId, double openPrice, double stopLoss, double takeProfit) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_MODIFY;
        trade.orderId = orderId;
        trade.openPrice = openPrice;
        trade.stopLoss = stopLoss;
        trade.takeProfit = takeProfit;
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> cancelOrder(String orderId) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_CANCEL;
        trade.orderId = orderId;
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<Void> reconnect() {
        return this.websocketClient.reconnect(this.account.getId());
    }

    public CompletableFuture<Void> synchronize() {
        return CompletableFuture.runAsync(() -> {
            IsoTime lastHistoryOrderTime = this.historyStorage.getLastHistoryOrderTime().join();
            IsoTime startingHistoryOrderTime = this.historyStartTime == null || lastHistoryOrderTime.getDate().compareTo(this.historyStartTime.getDate()) > 0 ? lastHistoryOrderTime : this.historyStartTime;
            IsoTime lastDealTime = this.historyStorage.getLastDealTime().join();
            IsoTime startingDealTime = this.historyStartTime == null || lastDealTime.getDate().compareTo(this.historyStartTime.getDate()) > 0 ? lastDealTime : this.historyStartTime;
            this.lastSynchronizationId = UUID.randomUUID().toString();
            this.websocketClient.synchronize(this.account.getId(), this.lastSynchronizationId, startingHistoryOrderTime, startingDealTime).join();
        });
    }

    public CompletableFuture<Void> initialize() {
        return CompletableFuture.runAsync(() -> this.historyStorage.loadData().join());
    }

    public CompletableFuture<Void> subscribe() {
        return this.websocketClient.subscribe(this.account.getId());
    }

    public CompletableFuture<Void> subscribeToMarketData(String symbol) {
        return CompletableFuture.runAsync(() -> this.websocketClient.subscribeToMarketData(this.account.getId(), symbol).join());
    }

    public CompletableFuture<MetatraderSymbolSpecification> getSymbolSpecification(String symbol) {
        return this.websocketClient.getSymbolSpecification(this.account.getId(), symbol);
    }

    public CompletableFuture<MetatraderSymbolPrice> getSymbolPrice(String symbol) {
        return this.websocketClient.getSymbolPrice(this.account.getId(), symbol);
    }

    public TerminalState getTerminalState() {
        return this.terminalState;
    }

    public HistoryStorage getHistoryStorage() {
        return this.historyStorage;
    }

    public void addSynchronizationListener(SynchronizationListener listener) {
        this.websocketClient.addSynchronizationListener(this.account.getId(), listener);
    }

    public void removeSynchronizationListener(SynchronizationListener listener) {
        this.websocketClient.removeSynchronizationListener(this.account.getId(), listener);
    }

    @Override
    public CompletableFuture<Void> onConnected() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.synchronize().join();
            }
            catch (CompletionException e) {
                logger.error((Object)"MetaApi websocket client failed to synchronize", e.getCause());
            }
        });
    }

    @Override
    public CompletableFuture<Void> onDisconnected() {
        this.lastDisconnectedSynchronizationId = this.lastSynchronizationId;
        this.lastSynchronizationId = null;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDealSynchronizationFinished(String synchronizationId) {
        return CompletableFuture.runAsync(() -> {
            this.dealsSynchronized.add(synchronizationId);
            this.historyStorage.updateStorage().join();
        });
    }

    @Override
    public CompletableFuture<Void> onOrderSynchronizationFinished(String synchronizationId) {
        this.ordersSynchronized.add(synchronizationId);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onReconnected() {
        try {
            return this.subscribe();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    public CompletableFuture<Boolean> isSynchronized(String synchronizationId) {
        if (synchronizationId == null) {
            synchronizationId = this.lastSynchronizationId;
        }
        return CompletableFuture.completedFuture(this.ordersSynchronized.contains(synchronizationId) && this.dealsSynchronized.contains(synchronizationId));
    }

    public CompletableFuture<Void> waitSynchronized() {
        return this.waitSynchronized(null);
    }

    public CompletableFuture<Void> waitSynchronized(SynchronizationOptions opts) {
        if (opts == null) {
            opts = new SynchronizationOptions();
        }
        String synchronizationId = opts.synchronizationId;
        int timeoutInSeconds = opts.timeoutInSeconds != null ? opts.timeoutInSeconds : 300;
        int intervalInMilliseconds = opts.intervalInMilliseconds != null ? opts.intervalInMilliseconds : 1000;
        long startTime = Instant.now().getEpochSecond();
        long timeoutTime = startTime + (long)timeoutInSeconds;
        return CompletableFuture.runAsync(() -> {
            try {
                boolean isSynchronized;
                while (!(isSynchronized = this.isSynchronized(synchronizationId).get().booleanValue()) && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds);
                }
                if (!isSynchronized) {
                    throw new TimeoutException("Timed out waiting for account MetApi to synchronize to MetaTrader account " + this.account.getId() + ", synchronization id " + (synchronizationId != null ? synchronizationId : (this.lastSynchronizationId != null ? this.lastSynchronizationId : this.lastDisconnectedSynchronizationId)));
                }
                this.websocketClient.waitSynchronized(this.account.getId(), ".*", Long.valueOf(timeoutInSeconds)).get();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public void close() {
        if (!this.closed) {
            this.websocketClient.removeSynchronizationListener(this.account.getId(), this);
            this.websocketClient.removeSynchronizationListener(this.account.getId(), this.terminalState);
            this.websocketClient.removeSynchronizationListener(this.account.getId(), this.historyStorage);
            this.connectionRegistry.remove(this.account.getId());
            this.closed = true;
        }
    }

    private void copyModelProperties(Object source, Object target) {
        Field[] publicFields = source.getClass().getFields();
        for (int i = 0; i < publicFields.length; ++i) {
            Field sourceField = publicFields[i];
            try {
                Field targetField = target.getClass().getField(sourceField.getName());
                targetField.set(target, sourceField.get(source));
                continue;
            }
            catch (NoSuchFieldException targetField) {
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Cannot copy model property " + sourceField.getName()), (Throwable)e);
            }
        }
    }
}

