/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.copy_factory;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.copy_factory.ConfigurationClient;
import cloud.metaapi.sdk.clients.copy_factory.HistoryClient;
import cloud.metaapi.sdk.clients.copy_factory.TradingClient;

public class CopyFactory {
    private ConfigurationClient configurationClient;
    private HistoryClient historyClient;
    private TradingClient tradingClient;

    public CopyFactory(String token) {
        this(token, "agiliumtrade.agiliumtrade.ai", 60, 60);
    }

    public CopyFactory(String token, String domain, int requestTimeout, int connectTimeout) {
        HttpClient httpClient = new HttpClient(requestTimeout * 1000, connectTimeout * 1000);
        this.configurationClient = new ConfigurationClient(httpClient, token, domain);
        this.historyClient = new HistoryClient(httpClient, token, domain);
        this.tradingClient = new TradingClient(httpClient, token, domain);
    }

    public ConfigurationClient getConfigurationApi() {
        return this.configurationClient;
    }

    public HistoryClient getHistoryApi() {
        return this.historyClient;
    }

    public TradingClient getTradingApi() {
        return this.tradingClient;
    }
}

