/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.meta_api.OutOfOrderListener;
import cloud.metaapi.sdk.clients.models.IsoTime;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class PacketOrderer {
    private OutOfOrderListener outOfOrderListener;
    private int orderingTimeoutInSeconds;
    private Map<String, Boolean> isOutOfOrderEmitted;
    private Map<String, AtomicInteger> sequenceNumberByAccount;
    private Map<String, List<Packet>> packetsByAccountId;
    private Timer outOfOrderJob;

    public PacketOrderer(OutOfOrderListener outOfOrderListener, Integer orderingTimeoutInSeconds) {
        this.outOfOrderListener = outOfOrderListener;
        this.orderingTimeoutInSeconds = orderingTimeoutInSeconds != null ? orderingTimeoutInSeconds : 10;
        this.isOutOfOrderEmitted = new HashMap<String, Boolean>();
    }

    public void start() {
        final PacketOrderer self = this;
        this.sequenceNumberByAccount = new HashMap<String, AtomicInteger>();
        this.packetsByAccountId = new HashMap<String, List<Packet>>();
        this.outOfOrderJob = new Timer();
        this.outOfOrderJob.schedule(new TimerTask(){

            @Override
            public void run() {
                self.emitOutOfOrderEvents();
            }
        }, 1000L, 1000L);
    }

    public void stop() {
        if (this.outOfOrderJob != null) {
            this.outOfOrderJob.cancel();
            this.outOfOrderJob = null;
        }
    }

    public List<JsonNode> restoreOrder(JsonNode packet) {
        int sequenceNumber;
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        int n = sequenceNumber = packet.has("sequenceNumber") ? packet.get("sequenceNumber").asInt() : -1;
        if (sequenceNumber == -1 || sequenceNumber == 0) {
            result.add(packet);
            return result;
        }
        String accountId = packet.get("accountId").asText();
        if (packet.get("type").asText().equals("specifications") && packet.has("synchronizationId")) {
            this.isOutOfOrderEmitted.put(accountId, false);
            this.sequenceNumberByAccount.put(accountId, new AtomicInteger(sequenceNumber));
            this.packetsByAccountId.remove(accountId);
            result.add(packet);
            return result;
        }
        if (this.sequenceNumberByAccount.containsKey(accountId) && sequenceNumber < this.sequenceNumberByAccount.get(accountId).get()) {
            return result;
        }
        if (this.sequenceNumberByAccount.containsKey(accountId) && sequenceNumber == this.sequenceNumberByAccount.get(accountId).get()) {
            result.add(packet);
            return result;
        }
        if (this.sequenceNumberByAccount.containsKey(accountId) && sequenceNumber == this.sequenceNumberByAccount.get(accountId).get() + 1) {
            this.sequenceNumberByAccount.get(accountId).incrementAndGet();
            result.add(packet);
            List waitList = this.packetsByAccountId.getOrDefault(accountId, new ArrayList());
            while (!(waitList.isEmpty() || ((Packet)waitList.get((int)0)).sequenceNumber != this.sequenceNumberByAccount.get(accountId).get() && ((Packet)waitList.get((int)0)).sequenceNumber != this.sequenceNumberByAccount.get(accountId).get() + 1)) {
                result.add(((Packet)waitList.get((int)0)).packet);
                if (((Packet)waitList.get((int)0)).sequenceNumber == this.sequenceNumberByAccount.get(accountId).get() + 1) {
                    this.sequenceNumberByAccount.get(accountId).getAndIncrement();
                }
                waitList.remove(0);
            }
            if (waitList.isEmpty()) {
                this.packetsByAccountId.remove(accountId);
            }
            return result;
        }
        if (this.sequenceNumberByAccount.containsKey(accountId)) {
            if (this.packetsByAccountId.get(accountId) == null) {
                this.packetsByAccountId.put(accountId, new ArrayList());
            }
            List<Packet> waitList = this.packetsByAccountId.get(accountId);
            Packet p = new Packet();
            p.accountId = accountId;
            p.sequenceNumber = sequenceNumber;
            p.packet = packet;
            p.receivedAt = new IsoTime(Date.from(Instant.now()));
            waitList.add(p);
            return result;
        }
        result.add(packet);
        return result;
    }

    private void emitOutOfOrderEvents() {
        this.packetsByAccountId.values().forEach(waitList -> {
            if (!waitList.isEmpty()) {
                String accountId;
                Packet packet = (Packet)waitList.get(0);
                if (packet == null) {
                    return;
                }
                Instant receivedAtPlusTimeout = packet.receivedAt.getDate().toInstant().plusSeconds(this.orderingTimeoutInSeconds);
                if (receivedAtPlusTimeout.compareTo(Instant.now()) < 0 && !this.isOutOfOrderEmitted.getOrDefault(accountId = packet.accountId, false).booleanValue()) {
                    this.isOutOfOrderEmitted.put(accountId, true);
                    this.outOfOrderListener.onOutOfOrderPacket(packet.accountId, this.sequenceNumberByAccount.get(accountId).get() + 1, packet.sequenceNumber, packet.packet, packet.receivedAt);
                }
            }
        });
    }

    private class Packet {
        public String accountId;
        public int sequenceNumber;
        public JsonNode packet;
        public IsoTime receivedAt;

        private Packet() {
        }
    }
}

