/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.MethodAccessException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class MetaApiClient {
    protected HttpClient httpClient;
    protected String host;
    protected String token;

    public MetaApiClient(HttpClient httpClient, String token) {
        this(httpClient, token, "agiliumtrade.agiliumtrade.ai");
    }

    public MetaApiClient(HttpClient httpClient, String token, String domain) {
        this.httpClient = httpClient;
        this.host = "https://mt-provisioning-api-v1." + domain;
        this.token = token;
    }

    protected String getTokenType() {
        if (this.token.split("\\.").length == 3) {
            return "api";
        }
        if (this.token.split("\\.").length == 1) {
            return "account";
        }
        return "";
    }

    protected boolean isNotJwtToken() {
        return this.token.split("\\.").length != 3;
    }

    protected boolean isNotAccountToken() {
        return this.token.split("\\.").length != 1;
    }

    protected <T> CompletableFuture<T> handleNoAccessError(String methodName) {
        return CompletableFuture.supplyAsync(() -> {
            throw new CompletionException(new MethodAccessException(methodName, this.getTokenType()));
        });
    }
}

