/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.copy_factory;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryStrategyIdAndName;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactorySubscriberOrProvider;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryTransaction;
import cloud.metaapi.sdk.clients.models.IsoTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class HistoryClient
extends MetaApiClient {
    public HistoryClient(HttpClient httpClient, String token) {
        this(httpClient, token, "agiliumtrade.agiliumtrade.ai");
    }

    public HistoryClient(HttpClient httpClient, String token, String domain) {
        super(httpClient, token, domain);
        this.host = "https://trading-api-v1." + domain;
    }

    public CompletableFuture<List<CopyFactorySubscriberOrProvider>> getProviders() {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getProviders");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/providers", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, CopyFactorySubscriberOrProvider[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<List<CopyFactorySubscriberOrProvider>> getSubscribers() {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getSubscribers");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/subscribers", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, CopyFactorySubscriberOrProvider[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<List<CopyFactoryStrategyIdAndName>> getStrategiesSubscribed() {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getStrategiesSubscribed");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/strategies-subscribed", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, CopyFactoryStrategyIdAndName[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<List<CopyFactoryStrategyIdAndName>> getProvidedStrategies() {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getProvidedStrategies");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provided-strategies", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, CopyFactoryStrategyIdAndName[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<List<CopyFactoryTransaction>> getProvidedStrategiesTransactions(IsoTime from, IsoTime till) {
        return this.getProvidedStrategiesTransactions(from, till, null, null, null, null, null);
    }

    public CompletableFuture<List<CopyFactoryTransaction>> getProvidedStrategiesTransactions(IsoTime from, IsoTime till, List<String> strategyIds, List<String> accountIds, List<String> subscriberIds) {
        return this.getProvidedStrategiesTransactions(from, till, strategyIds, accountIds, subscriberIds, null, null);
    }

    public CompletableFuture<List<CopyFactoryTransaction>> getProvidedStrategiesTransactions(IsoTime from, IsoTime till, List<String> strategyIds, List<String> accountIds, List<String> subscriberIds, Integer offset, Integer limit) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getProvidedStrategiesTransactions");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provided-strategies/transactions", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        opts.getQueryParameters().put("from", from);
        opts.getQueryParameters().put("till", till);
        if (strategyIds != null && !strategyIds.isEmpty()) {
            opts.getQueryParameters().put("strategyId", strategyIds);
        }
        if (accountIds != null && !accountIds.isEmpty()) {
            opts.getQueryParameters().put("accountId", accountIds);
        }
        if (subscriberIds != null && !subscriberIds.isEmpty()) {
            opts.getQueryParameters().put("subscriberId", subscriberIds);
        }
        if (offset != null) {
            opts.getQueryParameters().put("offset", offset);
        }
        if (limit != null) {
            opts.getQueryParameters().put("limit", limit);
        }
        return this.httpClient.requestJson(opts, CopyFactoryTransaction[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<List<CopyFactoryTransaction>> getStrategiesSubscribedTransactions(IsoTime from, IsoTime till) {
        return this.getStrategiesSubscribedTransactions(from, till, null, null, null, null, null);
    }

    public CompletableFuture<List<CopyFactoryTransaction>> getStrategiesSubscribedTransactions(IsoTime from, IsoTime till, List<String> strategyIds, List<String> accountIds, List<String> providerIds) {
        return this.getStrategiesSubscribedTransactions(from, till, strategyIds, accountIds, providerIds, null, null);
    }

    public CompletableFuture<List<CopyFactoryTransaction>> getStrategiesSubscribedTransactions(IsoTime from, IsoTime till, List<String> strategyIds, List<String> accountIds, List<String> providerIds, Integer offset, Integer limit) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getStrategiesSubscribedTransactions");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/strategies-subscribed/transactions", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        opts.getQueryParameters().put("from", from);
        opts.getQueryParameters().put("till", till);
        if (strategyIds != null && !strategyIds.isEmpty()) {
            opts.getQueryParameters().put("strategyId", strategyIds);
        }
        if (accountIds != null && !accountIds.isEmpty()) {
            opts.getQueryParameters().put("accountId", accountIds);
        }
        if (providerIds != null && !providerIds.isEmpty()) {
            opts.getQueryParameters().put("providerId", providerIds);
        }
        if (offset != null) {
            opts.getQueryParameters().put("offset", offset);
        }
        if (limit != null) {
            opts.getQueryParameters().put("limit", limit);
        }
        return this.httpClient.requestJson(opts, CopyFactoryTransaction[].class).thenApply(array -> Arrays.asList(array));
    }
}

