/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients;

public class MethodAccessException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String message;

    public MethodAccessException(String methodName) {
        this(methodName, "api");
    }

    public MethodAccessException(String methodName, String accessType) {
        switch (accessType) {
            case "api": {
                this.message = "You can not invoke " + methodName + " method, because you have connected with API access token. Please use account access token to invoke this method.";
                break;
            }
            case "account": {
                this.message = "You can not invoke " + methodName + " method, because you have connected with account access token. Please use API access token from https://app.metaapi.cloud/token page to invoke this method.";
                break;
            }
            default: {
                this.message = "";
            }
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

