/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.copy_factory;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.RetryOptions;
import cloud.metaapi.sdk.clients.copy_factory.ConfigurationClient;
import cloud.metaapi.sdk.clients.copy_factory.HistoryClient;
import cloud.metaapi.sdk.clients.copy_factory.TradingClient;

public class CopyFactory {
    private ConfigurationClient configurationClient;
    private HistoryClient historyClient;
    private TradingClient tradingClient;

    public CopyFactory(String token) {
        this(token, new Options());
    }

    public CopyFactory(String token, Options opts) {
        HttpClient httpClient = new HttpClient(opts.requestTimeout * 1000, opts.connectTimeout * 1000, opts.retryOpts);
        this.configurationClient = new ConfigurationClient(httpClient, token, opts.domain);
        this.historyClient = new HistoryClient(httpClient, token, opts.domain);
        this.tradingClient = new TradingClient(httpClient, token, opts.domain);
    }

    public ConfigurationClient getConfigurationApi() {
        return this.configurationClient;
    }

    public HistoryClient getHistoryApi() {
        return this.historyClient;
    }

    public TradingClient getTradingApi() {
        return this.tradingClient;
    }

    public static class Options {
        public String domain = "agiliumtrade.agiliumtrade.ai";
        public int requestTimeout = 60;
        public int connectTimeout = 60;
        public RetryOptions retryOpts = new RetryOptions();
    }
}

