/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.copy_factory;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.RetryOptions;
import cloud.metaapi.sdk.clients.copy_factory.ConfigurationClient;
import cloud.metaapi.sdk.clients.copy_factory.HistoryClient;
import cloud.metaapi.sdk.clients.copy_factory.TradingClient;

public class CopyFactory {
    private ConfigurationClient configurationClient;
    private HistoryClient historyClient;
    private TradingClient tradingClient;

    public CopyFactory(String token) {
        this(token, null);
    }

    public CopyFactory(String token, Options opts) {
        String domain = opts != null && opts.domain != null ? opts.domain : "agiliumtrade.agiliumtrade.ai";
        int requestTimeout = opts != null && opts.requestTimeout != null ? opts.requestTimeout : 60;
        int connectTimeout = opts != null && opts.connectTimeout != null ? opts.connectTimeout : 60;
        HttpClient httpClient = new HttpClient(requestTimeout * 1000, connectTimeout * 1000, opts.retryOpts);
        this.configurationClient = new ConfigurationClient(httpClient, token, domain);
        this.historyClient = new HistoryClient(httpClient, token, domain);
        this.tradingClient = new TradingClient(httpClient, token, domain);
    }

    public ConfigurationClient getConfigurationApi() {
        return this.configurationClient;
    }

    public HistoryClient getHistoryApi() {
        return this.historyClient;
    }

    public TradingClient getTradingApi() {
        return this.tradingClient;
    }

    public static class Options {
        public String domain;
        public Integer requestTimeout;
        public Integer connectTimeout;
        public RetryOptions retryOpts = new RetryOptions();
    }
}

