/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.copy_factory;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryStrategyStopout;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryUserLogRecord;
import cloud.metaapi.sdk.clients.models.IsoTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TradingClient
extends MetaApiClient {
    public TradingClient(HttpClient httpClient, String token) {
        this(httpClient, token, "agiliumtrade.agiliumtrade.ai");
    }

    public TradingClient(HttpClient httpClient, String token, String domain) {
        super(httpClient, token, domain);
        this.host = "https://trading-api-v1." + domain;
    }

    public CompletableFuture<Void> resynchronize(String accountId, List<String> strategyIds) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("resynchronize");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/resynchronize", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        if (strategyIds != null && !strategyIds.isEmpty()) {
            opts.getQueryParameters().put("strategyId", strategyIds);
        }
        return this.httpClient.request(opts).thenApply(response -> null);
    }

    public CompletableFuture<List<CopyFactoryStrategyStopout>> getStopouts(String accountId) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getStopouts");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/stopouts", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, CopyFactoryStrategyStopout[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<Void> resetStopouts(String accountId, String strategyId, String reason) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("resetStopouts");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/strategies-subscribed/" + strategyId + "/stopouts/" + reason + "/reset", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(response -> null);
    }

    public CompletableFuture<List<CopyFactoryUserLogRecord>> getUserLog(String accountId) {
        return this.getUserLog(accountId, null, null, null, null);
    }

    public CompletableFuture<List<CopyFactoryUserLogRecord>> getUserLog(String accountId, IsoTime startTime, IsoTime endTime) {
        return this.getUserLog(accountId, startTime, endTime, null, null);
    }

    public CompletableFuture<List<CopyFactoryUserLogRecord>> getUserLog(String accountId, IsoTime startTime, IsoTime endTime, Integer offset, Integer limit) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getUserLog");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/user-log", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        if (startTime != null) {
            opts.getQueryParameters().put("startTime", startTime);
        }
        if (endTime != null) {
            opts.getQueryParameters().put("endTime", endTime);
        }
        if (offset != null) {
            opts.getQueryParameters().put("offset", offset);
        }
        if (limit != null) {
            opts.getQueryParameters().put("limit", limit);
        }
        return this.httpClient.requestJson(opts, CopyFactoryUserLogRecord[].class).thenApply(array -> Arrays.asList(array));
    }
}

