/*
 * Decompiled with CFR 0.152.
 */
package cloud.gouyiba.autoconfigure;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.io.VFS;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SpringBootVFS
extends VFS {
    private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());

    public boolean isValid() {
        return true;
    }

    protected List<String> list(URL url, String path) throws IOException {
        String urlString = url.toString();
        String baseUrlString = urlString.endsWith("/") ? urlString : urlString.concat("/");
        Resource[] resources = this.resourceResolver.getResources(baseUrlString + "**/*.class");
        return Stream.of(resources).map(resource -> this.preserveSubpackageName(baseUrlString, (Resource)resource, path)).collect(Collectors.toList());
    }

    private String preserveSubpackageName(String baseUrlString, Resource resource, String rootPath) {
        try {
            return rootPath + (rootPath.endsWith("/") ? "" : "/") + resource.getURL().toString().substring(baseUrlString.length());
        }
        catch (IOException var5) {
            throw new UncheckedIOException(var5);
        }
    }
}

