/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.structure;

import cloud.elit.sdk.structure.Chunk;
import cloud.elit.sdk.structure.node.NLPNode;
import cloud.elit.sdk.structure.util.ELITUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class Sentence
implements Serializable,
Comparable<Sentence>,
Iterable<NLPNode> {
    private int sen_id;
    private NLPNode root;
    private List<NLPNode> nodes;
    private List<Chunk> named_entities;

    public <N> Sentence(int sen_id, List<N> nodes) {
        this.setID(sen_id);
        this.setRoot(ELITUtils.createRoot());
        this.setNamedEntities(new ArrayList<Chunk>());
        if (nodes == null || nodes.isEmpty()) {
            this.setNodes(new ArrayList<NLPNode>());
        } else {
            N node = nodes.get(0);
            if (node instanceof String) {
                List<NLPNode> ns = nodes;
                this.setNodes(IntStream.range(0, nodes.size()).mapToObj(i -> new NLPNode(i, (String)ns.get(i))).collect(Collectors.toList()));
            } else if (node instanceof NLPNode) {
                this.setNodes(nodes);
            } else {
                throw new IllegalArgumentException("The node type must be either String or NLPNode");
            }
        }
    }

    public <N> Sentence(List<N> nodes) {
        this(-1, nodes);
    }

    public Sentence() {
        this(new ArrayList());
    }

    public int getID() {
        return this.sen_id;
    }

    public void setID(int id) {
        this.sen_id = id;
    }

    public NLPNode getRoot() {
        return this.root;
    }

    public void setRoot(NLPNode node) {
        this.root = node;
    }

    public List<NLPNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<NLPNode> nodes) {
        this.nodes = nodes;
    }

    public int size() {
        return this.nodes.size();
    }

    public NLPNode get(int index) {
        return index < 0 ? this.root : this.nodes.get(index);
    }

    public boolean add(NLPNode node) {
        return this.nodes.add(node);
    }

    public void add(int index, NLPNode node) {
        this.nodes.add(index, node);
    }

    public NLPNode set(int index, NLPNode node) {
        return this.nodes.set(index, node);
    }

    public NLPNode remove(int index) {
        return this.nodes.remove(index);
    }

    public boolean remove(NLPNode node) {
        return this.nodes.remove(node);
    }

    public List<Chunk> getNamedEntities() {
        return this.named_entities;
    }

    public void setNamedEntities(List<Chunk> entities) {
        this.named_entities = entities;
    }

    public int numNamedEntities() {
        return this.named_entities.size();
    }

    public Chunk getNamedEntity(int index) {
        return this.named_entities.get(index);
    }

    public void addNamedEntity(Chunk entity) {
        this.named_entities.add(entity);
    }

    public List<String> getTokens() {
        return this.nodes.stream().map(NLPNode::getToken).collect(Collectors.toList());
    }

    public List<String> getLemmas() {
        return this.nodes.stream().map(NLPNode::getLemma).collect(Collectors.toList());
    }

    public List<String> getPartOfSpeechTags() {
        return this.nodes.stream().map(NLPNode::getPartOfSpeechTag).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Iterator<NLPNode> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public int compareTo(@NotNull Sentence o) {
        return this.sen_id - o.sen_id;
    }

    public String toString() {
        String s;
        if (this.nodes.isEmpty()) {
            return "{}";
        }
        NLPNode node = this.nodes.get(0);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("\"sid\":" + this.sen_id);
        joiner.add("\"tok\":" + this.toStringList(NLPNode::getToken));
        if (node.getEndOffset() > 0) {
            joiner.add("\"off\":" + this.toStringOffsets());
        }
        if (node.getLemma() != null) {
            joiner.add("\"lem\":" + this.toStringList(NLPNode::getLemma));
        }
        if (node.getPartOfSpeechTag() != null) {
            joiner.add("\"pos\":" + this.toStringList(NLPNode::getPartOfSpeechTag));
        }
        if (this.named_entities != null && !this.named_entities.isEmpty()) {
            joiner.add("\"ner\":" + this.named_entities.toString());
        }
        if (node.getDependencyLabel() != null) {
            joiner.add("\"dep\":" + this.toStringPrimaryDependencies());
        }
        if ((s = this.toStringSecondaryDependencies()) != null) {
            joiner.add("\"dep2\":" + s);
        }
        if ((s = this.toStringSemanticTags()) != null) {
            joiner.add("\"sem\":" + s);
        }
        return "{" + joiner.toString() + "}";
    }

    private String toStringList(Function<NLPNode, String> f) {
        return "[" + this.nodes.stream().map(n -> "\"" + ((String)f.apply((NLPNode)n)).replace("\"", "\\\"") + "\"").collect(Collectors.joining(",")) + "]";
    }

    private String toStringOffsets() {
        return "[" + this.nodes.stream().map(n -> "[" + n.getBeginOffset() + "," + n.getEndOffset() + "]").collect(Collectors.joining(",")) + "]";
    }

    private String toStringPrimaryDependencies() {
        return "[" + this.nodes.stream().map(n -> "[" + ((NLPNode)n.getParent()).getTokenID() + ",\"" + n.getDependencyLabel() + "\"]").collect(Collectors.joining(",")) + "]";
    }

    private String toStringSecondaryDependencies() {
        StringJoiner join = new StringJoiner(",");
        for (NLPNode node : this.nodes) {
            String s = node.getSecondaryParents().stream().map(a -> "[" + node.getTokenID() + "," + ((NLPNode)a.getNode()).getTokenID() + ",\"" + a.getLabel() + "\"]").collect(Collectors.joining(","));
            if (s.length() <= 0) continue;
            join.add(s);
        }
        return join.length() > 0 ? "[" + join.toString() + "]" : null;
    }

    private String toStringSemanticTags() {
        StringJoiner join = new StringJoiner(",");
        for (NLPNode node : this.nodes) {
            String s = node.getFeat("sem");
            if (s == null) continue;
            join.add("[" + node.getTokenID() + ",\"" + s + "\"]");
        }
        return join.length() > 0 ? "[" + join.toString() + "]" : null;
    }

    public String toTSV() {
        StringJoiner join = new StringJoiner("\n");
        List<List<String>> conll = this.nodes.stream().map(NLPNode::toTSV).collect(Collectors.toList());
        if (this.named_entities != null) {
            this.toTSVNamedEntities(conll);
        }
        return conll.stream().map(l -> l.stream().collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
    }

    private void toTSVNamedEntities(List<List<String>> conll) {
        for (Chunk chunk : this.named_entities) {
            int eidx;
            int bidx = chunk.get(0).getTokenID();
            if (bidx == (eidx = chunk.get(chunk.size() - 1).getTokenID())) {
                conll.get(bidx).add("U-" + chunk.getLabel());
                continue;
            }
            conll.get(bidx).add("B-" + chunk.getLabel());
            conll.get(eidx).add("L-" + chunk.getLabel());
            for (int i = bidx + 1; i < eidx; ++i) {
                conll.get(i).add("I-" + chunk.getLabel());
            }
        }
        for (List list : conll) {
            if (list.size() >= 9) continue;
            list.add("O");
        }
    }
}

