/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.structure;

import cloud.elit.sdk.structure.node.NLPNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Chunk
implements Serializable,
Iterable<NLPNode> {
    private List<NLPNode> nodes;
    private String label;

    public Chunk(List<NLPNode> nodes, String label) {
        this.setNodes(nodes);
        this.setLabel(label);
    }

    public Chunk(List<NLPNode> nodes) {
        this(nodes, null);
    }

    public Chunk() {
        this(new ArrayList<NLPNode>());
    }

    public List<NLPNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<NLPNode> nodes) {
        this.nodes = nodes;
    }

    public int size() {
        return this.nodes.size();
    }

    public NLPNode get(int index) {
        return this.nodes.get(index);
    }

    public boolean add(NLPNode node) {
        return this.nodes.add(node);
    }

    public void add(int index, NLPNode node) {
        this.nodes.add(index, node);
    }

    public NLPNode set(int index, NLPNode node) {
        return this.nodes.set(index, node);
    }

    public NLPNode remove(int index) {
        return this.nodes.remove(index);
    }

    public boolean remove(NLPNode node) {
        return this.nodes.remove(node);
    }

    public boolean contains(NLPNode node) {
        return this.nodes.contains(node);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isLabel(String label) {
        return label.equals(this.label);
    }

    public String toString() {
        if (this.nodes.isEmpty()) {
            return "[]";
        }
        StringBuilder build = new StringBuilder();
        build.append("[");
        build.append(this.nodes.get(0).getTokenID());
        build.append(",");
        build.append(this.nodes.get(this.nodes.size() - 1).getTokenID() + 1);
        if (this.label != null) {
            build.append(",\"");
            build.append(this.label);
            build.append("\"");
        }
        build.append("]");
        return build.toString();
    }

    @Override
    @NotNull
    public Iterator<NLPNode> iterator() {
        return this.nodes.iterator();
    }
}

