/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.structure.util;

import cloud.elit.sdk.structure.node.NLPNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ELITUtils {
    public static final String RTAG = "@#r$%";

    public static NLPNode createRoot() {
        return new NLPNode(-1, RTAG, RTAG, RTAG, new HashMap<String, String>());
    }

    public static List<NLPNode> toNLPNodes(List<String> tokens) {
        return ELITUtils.toNLPNodes(tokens, 0, tokens.size());
    }

    public static List<NLPNode> toNLPNodes(String[] tokens) {
        return ELITUtils.toNLPNodes(tokens, 0, tokens.length);
    }

    public static List<NLPNode> toNLPNodes(List<String> tokens, int begin, int end) {
        ArrayList<NLPNode> nodes = new ArrayList<NLPNode>();
        for (int i = begin; i < end; ++i) {
            nodes.add(new NLPNode(i - begin, tokens.get(i)));
        }
        return nodes;
    }

    public static List<NLPNode> toNLPNodes(String[] tokens, int begin, int end) {
        ArrayList<NLPNode> nodes = new ArrayList<NLPNode>();
        for (int i = begin; i < end; ++i) {
            nodes.add(new NLPNode(i - begin, tokens[i]));
        }
        return nodes;
    }

    public static <T extends Comparable<T>> int binarySearch(List<T> list, T key) {
        int index = Collections.binarySearch(list, key);
        return index < 0 ? -(index + 1) : index + 1;
    }

    public static String getModulePath(String path, String dir) {
        File f = new File((String)path);
        try {
            String p = f.getCanonicalPath();
            if (!p.endsWith(dir)) {
                path = (String)path + "/" + dir;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path;
    }
}

