/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.structure.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.magicwerk.brownies.collections.GapList;

public abstract class Node<N extends Node<N>>
implements Serializable {
    protected N parent = null;
    protected N left_sibling = null;
    protected N right_sibling = null;
    protected final List<N> children = new GapList();

    public abstract N self();

    public abstract int indexOf(N var1);

    protected abstract int getDefaultIndex(List<N> var1, N var2);

    public N getChild(int index) {
        return (N)(0 <= index && index < this.children.size() ? (Node)this.children.get(index) : null);
    }

    public N getFirstChild() {
        return this.getFirstChild(0);
    }

    public N getFirstChild(int order) {
        return this.getChild(order);
    }

    public N getFirstChild(Predicate<N> matcher) {
        return (N)((Node)this.children.stream().filter(matcher).findFirst().orElse(null));
    }

    public N getLastChild() {
        return this.getLastChild(0);
    }

    public N getLastChild(int order) {
        return this.getChild(this.children.size() - order - 1);
    }

    public N getLastChild(Predicate<N> matcher) {
        return (N)((Node)this.children.stream().filter(matcher).reduce((a, b) -> b).orElse(null));
    }

    public boolean addChild(N node) {
        return this.addChild(this.getDefaultIndex(this.children, node), node);
    }

    public boolean addChild(int index, N node) {
        if (!this.isParentOf(node)) {
            if (((Node)node).hasParent()) {
                ((Node)((Node)node).parent).removeChild(node);
            }
            ((Node)node).parent = this.self();
            this.children.add(index, node);
            this.setSiblings(this.getChild(index - 1), node);
            this.setSiblings(node, this.getChild(index + 1));
            return true;
        }
        return false;
    }

    public N setChild(int index, N node) {
        if (!this.isParentOf(node)) {
            if (((Node)node).hasParent()) {
                ((Node)((Node)node).parent).removeChild(node);
            }
            ((Node)node).parent = this.self();
            Node old = (Node)this.children.set(index, node);
            this.setSiblings(this.getChild(index - 1), node);
            this.setSiblings(node, this.getChild(index + 1));
            old.isolate();
            return (N)old;
        }
        return null;
    }

    public N removeChild(N node) {
        return this.removeChild(this.indexOf(node));
    }

    public N removeChild(int index) {
        if (0 <= index && index < this.children.size()) {
            this.setSiblings(this.getChild(index - 1), this.getChild(index + 1));
            Node node = (Node)this.children.remove(index);
            node.isolate();
            return (N)node;
        }
        return null;
    }

    public boolean replaceChild(N old_child, N new_child) {
        int index = this.indexOf(old_child);
        if (index >= 0) {
            if (((Node)new_child).hasParent()) {
                ((Node)((Node)new_child).parent).removeChild(new_child);
            }
            this.setChild(index, new_child);
            return true;
        }
        return false;
    }

    public void removeSelf() {
        N node = this.self();
        while (((Node)node).hasParent()) {
            N parent = ((Node)node).parent;
            ((Node)parent).removeChild(node);
            if (((Node)parent).hasChild()) break;
            node = parent;
        }
    }

    public boolean hasChild() {
        return !this.children.isEmpty();
    }

    public boolean isChildOf(N node) {
        return node != null && this.parent == node;
    }

    public boolean containsChild(Predicate<N> matcher) {
        return this.children.stream().anyMatch(matcher);
    }

    public int numChildren() {
        return this.children.size();
    }

    public List<N> getChildren() {
        return this.children;
    }

    public List<N> getChildren(int fst_id) {
        return this.children.subList(fst_id, this.numChildren());
    }

    public List<N> getChildren(int fst_id, int lst_id) {
        return this.children.subList(fst_id, lst_id);
    }

    public List<N> getChildren(Predicate<N> matcher) {
        return this.children.stream().filter(matcher).collect(Collectors.toList());
    }

    public List<N> getGrandChildren() {
        return this.getSecondOrder(Node::getChildren);
    }

    public N getFirstDescendant(Predicate<N> matcher) {
        return this.getFirstDescendantAux(this.children, matcher);
    }

    private N getFirstDescendantAux(Collection<N> nodes, Predicate<N> matcher) {
        for (Node<N> node : nodes) {
            if (matcher.test(node)) {
                return (N)node;
            }
            node = this.getFirstDescendantAux(node.children, matcher);
            if (node == null) continue;
            return (N)node;
        }
        return null;
    }

    public N getFirstLowestChainedDescendant(Predicate<N> matcher) {
        N descendant = null;
        for (N node = this.getFirstChild(matcher); node != null; node = ((Node)node).getFirstChild(matcher)) {
            descendant = node;
        }
        return descendant;
    }

    public List<N> getDescendants() {
        return this.flatten().collect(Collectors.toList());
    }

    public List<N> getDescendants(int depth) {
        ArrayList list = new ArrayList();
        return depth > 0 ? this.getDescendantListAux(depth - 1, this.self(), list) : list;
    }

    private List<N> getDescendantListAux(int depth, N node, List<N> list) {
        list.addAll(((Node)node).getChildren());
        if (depth-- > 0) {
            for (Node dep : ((Node)node).getChildren()) {
                this.getDescendantListAux(depth, dep, list);
            }
        }
        return list;
    }

    public N getSingleChained(Predicate<N> matcher) {
        for (N node = this.self(); node != null; node = ((Node)node).getFirstChild()) {
            if (matcher.test(node)) {
                return node;
            }
            if (((Node)node).numChildren() != 1) break;
        }
        return null;
    }

    public void adaptDependents(N from) {
        for (Node d : ((Node)from).children) {
            d.setParent(this.self());
        }
    }

    public boolean isDescendantOf(N node) {
        return this.getNearestNode(n -> n == node, Node::getParent) != null;
    }

    public N getParent() {
        return this.parent;
    }

    public N getGrandParent() {
        return this.getAncestor(2);
    }

    public N getAncestor(int height) {
        return (N)this.getNode(height, n -> n.parent);
    }

    public N getLowestAncestor(Predicate<N> matcher) {
        return (N)this.getNearestNode(matcher, Node::getParent);
    }

    public N getHighestChainedAncestor(Predicate<N> matcher) {
        N node = this.parent;
        N ancestor = null;
        while (node != null && matcher.test(node)) {
            ancestor = node;
            node = ((Node)node).parent;
        }
        return ancestor;
    }

    public Set<N> getAncestorSet() {
        HashSet<N> set = new HashSet<N>();
        for (N node = this.getParent(); node != null; node = ((Node)node).getParent()) {
            set.add(node);
        }
        return set;
    }

    public N getLowestCommonAncestor(N node) {
        Set<N> set = this.getAncestorSet();
        set.add(this.self());
        while (node != null) {
            if (set.contains(node)) {
                return node;
            }
            node = ((Node)node).getParent();
        }
        return null;
    }

    public void setParent(N node) {
        if (node == null) {
            if (this.hasParent()) {
                ((Node)this.parent).removeChild(this.self());
            }
        } else {
            ((Node)node).addChild(this.self());
        }
    }

    public boolean isParentOf(N node) {
        return ((Node)node).isChildOf(this.self());
    }

    public boolean isAncestorOf(N node) {
        return ((Node)node).isDescendantOf(this.self());
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasParent(Predicate<N> matcher) {
        return this.hasParent() && matcher.test(this.parent);
    }

    public boolean hasGrandParent() {
        return this.getGrandParent() != null;
    }

    public List<N> getSiblings() {
        return this.hasParent() ? ((Node)this.parent).children.stream().filter(n -> n != this.self()).collect(Collectors.toList()) : new ArrayList();
    }

    public N getLeftNearestSibling() {
        return this.left_sibling;
    }

    public N getLeftNearestSibling(int order) {
        return (N)(order >= 0 ? this.getNode(order + 1, Node::getLeftNearestSibling) : null);
    }

    public N getLeftNearestSibling(Predicate<N> matcher) {
        return (N)this.getNearestNode(matcher, Node::getLeftNearestSibling);
    }

    public N getRightNearestSibling() {
        return this.right_sibling;
    }

    public N getRightNearestSibling(int order) {
        return (N)(order >= 0 ? this.getNode(order + 1, Node::getRightNearestSibling) : null);
    }

    public N getRightNearestSibling(Predicate<N> matcher) {
        return (N)this.getNearestNode(matcher, Node::getRightNearestSibling);
    }

    public boolean hasLeftSibling() {
        return this.left_sibling != null;
    }

    public boolean hasLeftSibling(Predicate<N> matcher) {
        return this.getLeftNearestSibling(matcher) != null;
    }

    public boolean hasRightSibling() {
        return this.right_sibling != null;
    }

    public boolean hasRightSibling(Predicate<N> matcher) {
        return this.getRightNearestSibling(matcher) != null;
    }

    public boolean isSiblingOf(N node) {
        return ((Node)node).isChildOf(this.parent);
    }

    public boolean isLeftSiblingOf(N node) {
        return node != null && this.parent == ((Node)node).parent && this.getNearestNode(n -> n == node, Node::getRightNearestSibling) != null;
    }

    public boolean isRightSiblingOf(N node) {
        return ((Node)node).isLeftSiblingOf(this.self());
    }

    public Stream<N> flatten() {
        return Stream.concat(Stream.of(this.self()), this.children.stream().flatMap(Node::flatten));
    }

    public N getNode(int order, Function<N, N> getter) {
        Object node = this.self();
        for (int i = 0; i < order; ++i) {
            if (node == null) {
                return null;
            }
            node = (Node)getter.apply(node);
        }
        return node;
    }

    public N getNearestNode(Predicate<N> matcher, Function<N, N> getter) {
        Node node = (Node)getter.apply(this.self());
        while (node != null) {
            if (matcher.test(node)) {
                return (N)node;
            }
            node = (Node)getter.apply(node);
        }
        return null;
    }

    public int distanceToTop() {
        N node = this.parent;
        int dist = 0;
        while (node != null) {
            node = ((Node)node).parent;
            ++dist;
        }
        return dist;
    }

    protected void isolate() {
        this.parent = null;
        this.left_sibling = null;
        this.right_sibling = null;
    }

    protected void setSiblings(N left, N right) {
        if (left != null) {
            ((Node)left).right_sibling = right;
        }
        if (right != null) {
            ((Node)right).left_sibling = left;
        }
    }

    protected List<N> getSecondOrder(Function<N, List<N>> getter) {
        return getter.apply(this.self()).stream().flatMap(n -> ((List)getter.apply(n)).stream()).filter(n -> n != this.self()).collect(Collectors.toList());
    }
}

