/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.structure.node;

import cloud.elit.sdk.structure.node.NLPArc;
import cloud.elit.sdk.structure.node.Node;
import cloud.elit.sdk.structure.util.ELITUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NLPNode
extends Node<NLPNode>
implements Comparable<NLPNode> {
    private int token_id;
    private String token;
    private String lemma;
    private String pos_tag;
    private String dep_label;
    private Map<String, String> feat_map;
    private int begin_offset;
    private int end_offset;
    protected List<NLPArc> snd_parents;

    public NLPNode(int token_id, String token, String lemma, String pos_tag, Map<String, String> feat_map) {
        this.setTokenID(token_id);
        this.setToken(token);
        this.setLemma(lemma);
        this.setPartOfSpeechTag(pos_tag);
        this.setDependencyLabel(null);
        this.setFeatMap(feat_map);
        this.setBeginOffset(-1);
        this.setEndOffset(-1);
        this.snd_parents = new ArrayList<NLPArc>();
    }

    public NLPNode(int token_id, String token, String pos_tag, Map<String, String> feat_map) {
        this(token_id, token, null, pos_tag, feat_map);
    }

    public NLPNode(int token_id, String token, String pos_tag) {
        this(token_id, token, pos_tag, new HashMap<String, String>());
    }

    public NLPNode(int token_id, String token) {
        this(token_id, token, null);
    }

    public NLPNode(String token) {
        this(-1, token);
    }

    @Override
    public NLPNode self() {
        return this;
    }

    @Override
    public int indexOf(NLPNode child) {
        return Collections.binarySearch(this.children, child);
    }

    @Override
    protected int getDefaultIndex(List<NLPNode> list, NLPNode node) {
        return ELITUtils.binarySearch(list, node);
    }

    public int getTokenID() {
        return this.token_id;
    }

    public void setTokenID(int id) {
        this.token_id = id;
    }

    public boolean isTokenID(int id) {
        return id == this.token_id;
    }

    public int getBeginOffset() {
        return this.begin_offset;
    }

    public void setBeginOffset(int offset) {
        this.begin_offset = offset;
    }

    public boolean isBeginOffset(int offset) {
        return this.begin_offset == offset;
    }

    public int getEndOffset() {
        return this.end_offset;
    }

    public void setEndOffset(int offset) {
        this.end_offset = offset;
    }

    public boolean isEndOffset(int offset) {
        return this.end_offset == offset;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isToken(String token) {
        return token.equals(this.token);
    }

    public boolean isToken(Pattern tokens) {
        return tokens.matcher(this.token).find();
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public boolean isLemma(String lemma) {
        return lemma.equals(this.lemma);
    }

    public String getPartOfSpeechTag() {
        return this.pos_tag;
    }

    public void setPartOfSpeechTag(String tag) {
        this.pos_tag = tag;
    }

    public boolean isPartOfSpeechTag(String tag) {
        return tag.equals(this.pos_tag);
    }

    public boolean isPartOfSpeechTag(Pattern tags) {
        return tags.matcher(this.pos_tag).find();
    }

    public boolean isPartOfSpeechTag(Collection<String> tags) {
        return tags.contains(this.pos_tag);
    }

    public boolean isPartOfSpeechTag(String ... tags) {
        return Arrays.stream(tags).anyMatch(this::isPartOfSpeechTag);
    }

    public String getDependencyLabel() {
        return this.dep_label;
    }

    public void setDependencyLabel(String label) {
        this.dep_label = label;
    }

    public boolean isDependencyLabel(String label) {
        return label.equals(this.dep_label);
    }

    public boolean isDependencyLabel(Pattern pattern) {
        return pattern.matcher(this.dep_label).find();
    }

    public boolean isDependencyLabel(String ... labels) {
        return Arrays.stream(labels).anyMatch(this::isDependencyLabel);
    }

    public Map<String, String> getFeatMap() {
        return this.feat_map;
    }

    public void setFeatMap(Map<String, String> map) {
        this.feat_map = map;
    }

    public String getFeat(String key) {
        return this.feat_map.get(key);
    }

    public String putFeat(String key, String value) {
        return this.feat_map.put(key, value);
    }

    public String removeFeat(String key) {
        return this.feat_map.remove(key);
    }

    public boolean containsFeat(String key) {
        return this.feat_map.containsKey(key);
    }

    public boolean isChildOf(NLPNode node, String label) {
        return this.isChildOf(node) && this.isDependencyLabel(label);
    }

    public void addChild(NLPNode child, String label) {
        this.addChild(child);
        this.setDependencyLabel(label);
    }

    public NLPNode getLeftMostChild() {
        return this.getLeftMostChild(0);
    }

    public NLPNode getLeftMostChild(int order) {
        NLPNode node = (NLPNode)this.getFirstChild(order);
        return node != null && this.compareTo(node) < 0 ? node : null;
    }

    public NLPNode getRightMostChild() {
        return this.getRightMostChild(0);
    }

    public NLPNode getRightMostChild(int order) {
        NLPNode node = (NLPNode)this.getLastChild(order);
        return node != null && this.compareTo(node) > 0 ? node : null;
    }

    public NLPNode getLeftNearestChild() {
        return this.getLeftNearestChild(0);
    }

    public NLPNode getLeftNearestChild(int order) {
        return (NLPNode)this.getChild(this.getDefaultIndex((List<NLPNode>)this.children, this.self()) - order - 1);
    }

    public NLPNode getRightNearestChild() {
        return this.getRightNearestChild(0);
    }

    public NLPNode getRightNearestChild(int order) {
        return (NLPNode)this.getChild(this.getDefaultIndex((List<NLPNode>)this.children, this.self()) + order);
    }

    public List<NLPNode> getLeftChildren() {
        int index = this.getDefaultIndex((List<NLPNode>)this.children, this.self());
        return this.children.subList(0, index);
    }

    public List<NLPNode> getRightChildren() {
        int index = this.getDefaultIndex((List<NLPNode>)this.children, this.self());
        return this.children.subList(index, this.children.size());
    }

    public String getValency() {
        String l = this.getLeftValency();
        String r = this.getRightValency();
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return l + r;
    }

    public String getLeftValency() {
        if (this.getLeftMostChild(1) != null) {
            return "[[";
        }
        if (this.getLeftMostChild() != null) {
            return "[";
        }
        return null;
    }

    public String getRightValency() {
        if (this.getRightMostChild(1) != null) {
            return "]]";
        }
        if (this.getRightMostChild() != null) {
            return "]";
        }
        return null;
    }

    public void setParent(NLPNode parent, String label) {
        this.setParent(parent);
        this.setDependencyLabel(label);
    }

    public List<NLPArc> getSecondaryParents() {
        return this.snd_parents;
    }

    public List<NLPArc> getSecondaryParents(String label) {
        ArrayList<NLPArc> list = new ArrayList<NLPArc>();
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isLabel(label)) continue;
            list.add(arc);
        }
        return list;
    }

    public NLPArc getSecondaryParent(NLPNode node) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isNode(node)) continue;
            return arc;
        }
        return null;
    }

    public NLPArc getSecondaryParent(NLPNode node, String label) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.equals(node, label)) continue;
            return arc;
        }
        return null;
    }

    public NLPArc getSecondaryParent(NLPNode node, Pattern pattern) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.equals(node, pattern)) continue;
            return arc;
        }
        return null;
    }

    public NLPArc getFirstSecondaryParent(String label) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isLabel(label)) continue;
            return arc;
        }
        return null;
    }

    public NLPArc getFirstSecondaryParent(Pattern pattern) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isLabel(pattern)) continue;
            return arc;
        }
        return null;
    }

    public void addSecondaryParents(Collection<NLPArc> arcs) {
        this.snd_parents.addAll(arcs);
    }

    public void addSecondaryParent(NLPNode head, String label) {
        this.addSecondaryParent(new NLPArc(head, label));
    }

    public void addSecondaryParent(NLPArc arc) {
        this.snd_parents.add(arc);
    }

    public void setSecondaryParents(List<NLPArc> arcs) {
        this.snd_parents = arcs;
    }

    public boolean removeSecondaryParent(NLPNode node) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isNode(node)) continue;
            return this.snd_parents.remove(arc);
        }
        return false;
    }

    public boolean removeSecondaryParent(NLPArc arc) {
        return this.snd_parents.remove(arc);
    }

    public void removeSecondaryParents(Collection<NLPArc> arcs) {
        this.snd_parents.removeAll(arcs);
    }

    public void removeSecondaryParents(String label) {
        this.snd_parents.removeAll(this.getSecondaryParents(label));
    }

    public List<NLPArc> clearSecondaryParents() {
        List<NLPArc> backup = this.snd_parents.subList(0, this.snd_parents.size());
        this.snd_parents.clear();
        return backup;
    }

    public boolean isSecondaryChildOf(NLPNode node) {
        return this.getSecondaryParent(node) != null;
    }

    public boolean isSecondaryChildOf(String label) {
        return this.getFirstSecondaryParent(label) != null;
    }

    public boolean isSecondaryChildOf(Pattern pattern) {
        return this.getFirstSecondaryParent(pattern) != null;
    }

    public boolean isSecondaryChildOf(NLPNode node, String label) {
        return this.getSecondaryParent(node, label) != null;
    }

    public boolean isSecondaryChildOf(NLPNode node, Pattern pattern) {
        return this.getSecondaryParent(node, pattern) != null;
    }

    @Override
    public int compareTo(@NotNull NLPNode o) {
        return this.token_id - o.token_id;
    }

    public List<String> toTSV() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Integer.toString(this.token_id + 1));
        list.add(this.toTSV(this.token));
        list.add(this.toTSV(this.lemma));
        list.add(this.toTSV(this.pos_tag));
        list.add(this.toTSVFeatMap());
        this.toTSVDependency(list);
        list.add(this.toTSV(this.snd_parents));
        return list;
    }

    private String toTSV(String s) {
        return s == null ? "_" : s;
    }

    private String toTSV(List<NLPArc> arcs) {
        if (arcs == null || arcs.isEmpty()) {
            return "_";
        }
        return arcs.stream().sorted().map(NLPArc::toTSV).collect(Collectors.joining("|"));
    }

    public String toTSVFeatMap() {
        if (this.feat_map == null || this.feat_map.isEmpty()) {
            return "_";
        }
        return this.feat_map.entrySet().stream().sorted().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("|"));
    }

    private void toTSVDependency(List<String> list) {
        if (this.hasParent()) {
            list.add(Integer.toString(((NLPNode)this.parent).token_id + 1));
            list.add(this.toTSV(this.dep_label));
        } else {
            list.add("_");
            list.add("_");
        }
    }
}

