/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.structure.node;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Arc<N extends Comparable<N>>
implements Comparable<Arc<N>>,
Serializable {
    protected N node;
    protected String label;

    public Arc(N node, String label) {
        this.set(node, label);
    }

    public N getNode() {
        return this.node;
    }

    public String getLabel() {
        return this.label;
    }

    public void setNode(N node) {
        this.node = node;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void set(N node, String label) {
        this.setNode(node);
        this.setLabel(label);
    }

    public boolean isNode(N node) {
        return this.node == node;
    }

    public boolean isLabel(String label) {
        return label != null && label.equals(this.label);
    }

    public boolean isLabel(Pattern labels) {
        return this.label != null && labels.matcher(this.label).find();
    }

    public boolean equals(N node, String label) {
        return this.isNode(node) && this.isLabel(label);
    }

    public boolean equals(N node, Pattern labels) {
        return this.isNode(node) && this.isLabel(labels);
    }

    public void clear() {
        this.set(null, null);
    }

    @Override
    public int compareTo(@NotNull Arc<N> arc) {
        return this.node.compareTo(arc.node);
    }
}

