/*
 * Copyright 2018 Emory University
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cloud.elit.sdk.structure.node;

/**
 * @author Jinho D. Choi ({@code jinho.choi@emory.edu})
 */
public class NLPArc extends Arc<NLPNode> {
    public NLPArc(NLPNode node, String label) {
        super(node, label);
    }

    @Override
    public String toString() {
        return "[" + node.getTokenID() + ",\"" + label + "\"]";
    }

    public String toTSV() {
        return node.getTokenID()+1 + ":" + label;
    }
}