/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.util;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DSUtils {
    public static <N> N getFirst(List<N> list) {
        return list.get(0);
    }

    public static <N> N getLast(List<N> list) {
        return list.get(list.size() - 1);
    }

    public static <N> N getFirst(List<N> list, Predicate<N> matcher) {
        return list.stream().filter(matcher).findFirst().orElse(null);
    }

    public static <N> N getLast(List<N> list, Predicate<N> matcher) {
        return list.stream().filter(n -> matcher.test(n)).reduce((a, b) -> b).orElse(null);
    }

    public static <N> List<N> getMatchedList(List<N> list, Predicate<N> matcher) {
        return list.stream().filter(n -> matcher.test(n)).collect(Collectors.toList());
    }

    public static <N> boolean contains(List<N> list, Predicate<N> matcher) {
        return list.stream().anyMatch(n -> matcher.test(n));
    }

    public static <N> boolean isRange(List<N> list, int index) {
        return 0 <= index && index < list.size();
    }

    public static <T extends Comparable<T>> int binarySearch(List<T> list, T key) {
        int index = Collections.binarySearch(list, key);
        return index < 0 ? -(index + 1) : index + 1;
    }
}

