/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Joiner {
    public static <T> String join(Collection<T> collection, String delim) {
        return Joiner.join(collection, delim, p -> p.toString());
    }

    public static <T> String join(Collection<T> collection, String delim, Function<T, String> f) {
        return collection.stream().map(f).collect(Collectors.joining(delim));
    }

    public static <T> String join(T[] array, String delim, int beginIndex, int endIndex, Function<T, String> f) {
        if (endIndex <= beginIndex) {
            return "";
        }
        StringJoiner build = new StringJoiner(delim);
        for (int i = beginIndex; i < endIndex; ++i) {
            build.add(f.apply(array[i]));
        }
        return build.toString();
    }

    public static <T> String join(T[] array, String delim, int beginIndex, int endIndex) {
        return Joiner.join(array, delim, beginIndex, endIndex, (T n) -> n.toString());
    }

    public static <T> String join(T[] array, String delim, int beginIndex) {
        return Joiner.join(array, delim, beginIndex, array.length, (T n) -> n.toString());
    }

    public static <T> String join(T[] array, String delim) {
        return Joiner.join(array, delim, 0, array.length);
    }

    public static <T> String join(List<T> list, String delim, int beginIndex, int endIndex, Function<T, String> f) {
        if (endIndex - beginIndex == 0) {
            return "";
        }
        StringJoiner build = new StringJoiner(delim);
        for (int i = beginIndex; i < endIndex; ++i) {
            build.add(f.apply(list.get(i)));
        }
        return build.toString();
    }

    public static <T> String join(List<T> list, String delim, int beginIndex) {
        return Joiner.join(list, delim, beginIndex, list.size(), Object::toString);
    }

    public static <T> String join(List<T> list, String delim, int beginIndex, int endIndex) {
        return Joiner.join(list, delim, beginIndex, endIndex, Object::toString);
    }

    public static <T extends Comparable<T>> String join(List<T> list, String delim, boolean sort) {
        if (sort) {
            Collections.sort(list);
        }
        return Joiner.join(list, delim, 0, list.size());
    }
}

