/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.util;

import java.util.ArrayList;
import java.util.List;

public class CharTokenizer {
    private char delim;

    public CharTokenizer(char delim) {
        this.setDelimiter(delim);
    }

    public char getDelimiter() {
        return this.delim;
    }

    public void setDelimiter(char delim) {
        this.delim = delim;
    }

    public List<String> tokenize(String s) {
        return this.tokenize(s, false);
    }

    public List<String> tokenize(String s, boolean include_empty) {
        ArrayList<String> list = new ArrayList<String>();
        int bIndex = 0;
        int len = s.length();
        char[] cs = s.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (cs[i] != this.delim) continue;
            if (bIndex < i) {
                list.add(s.substring(bIndex, i));
            } else if (include_empty) {
                list.add("");
            }
            bIndex = i + 1;
        }
        if (list.isEmpty()) {
            list.add(s);
            return list;
        }
        if (bIndex < len) {
            list.add(s.substring(bIndex));
        }
        return list;
    }

    public String[] toArray(String s, boolean include_empty) {
        List<String> list = this.tokenize(s, include_empty);
        return list.toArray(new String[list.size()]);
    }

    public String[] toArray(String s) {
        return this.toArray(s, false);
    }
}

