/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.structure.node;

import cloud.elit.sdk.nlp.structure.node.AbstractNode;
import cloud.elit.sdk.nlp.structure.node.NLPArc;
import cloud.elit.sdk.util.DSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class NLPNode
extends AbstractNode<NLPNode>
implements Comparable<NLPNode> {
    protected String dep_label;
    protected List<NLPArc> snd_parents;
    protected int begin_offset;
    protected int end_offset;

    public NLPNode(int token_id, String token, String lemma, String pos_tag, String ner_tag, Map<String, String> feat_map, NLPNode parent, String dep_label) {
        super(token_id, token, lemma, pos_tag, ner_tag, feat_map);
        this.setParent(parent, dep_label);
        this.snd_parents = new ArrayList<NLPArc>();
        this.end_offset = -1;
        this.begin_offset = -1;
    }

    public NLPNode(int token_id, String token, String lemma, String pos_tag, Map<String, String> feat_map, NLPNode parent, String dep_label) {
        this(token_id, token, lemma, pos_tag, null, feat_map, parent, dep_label);
    }

    public NLPNode(int token_id, String word_token, String lemma, String pos_tag, String ner_tag, Map<String, String> feat_map) {
        this(token_id, word_token, lemma, pos_tag, ner_tag, feat_map, null, null);
    }

    public NLPNode(int token_id, String token, String lemma, String pos_tag, Map<String, String> feat_map) {
        this(token_id, token, lemma, pos_tag, feat_map, null, null);
    }

    public NLPNode(int token_id, String token, String pos_tag) {
        this(token_id, token, null, pos_tag, new HashMap<String, String>());
    }

    public NLPNode(int id, String token) {
        this(id, token, null);
    }

    public NLPNode(int id) {
        this(id, null);
    }

    public NLPNode() {
        this(-2);
    }

    @Override
    public NLPNode self() {
        return this;
    }

    @Override
    public int getChildIndex(NLPNode node) {
        return Collections.binarySearch(this.children, node);
    }

    @Override
    protected int getDefaultIndex(List<NLPNode> list, NLPNode node) {
        return DSUtils.binarySearch(list, node);
    }

    public String getPartOfSpeechTag() {
        return this.syn_tag;
    }

    public void setPartOfSpeechTag(String tag) {
        this.syn_tag = tag;
    }

    public String getDependencyLabel() {
        return this.dep_label;
    }

    public void setDependencyLabel(String label) {
        this.dep_label = label;
    }

    public boolean isDependencyLabel(String label) {
        return label.equals(this.dep_label);
    }

    public boolean isDependencyLabel(Pattern pattern) {
        return pattern.matcher(this.dep_label).find();
    }

    public boolean isDependencyLabel(String ... labels) {
        for (String label : labels) {
            if (!this.isDependencyLabel(label)) continue;
            return true;
        }
        return false;
    }

    public int getBeginOffset() {
        return this.begin_offset;
    }

    public int getEndOffset() {
        return this.end_offset;
    }

    public void setBeginOffset(int offset) {
        this.begin_offset = offset;
    }

    public void setEndOffset(int offset) {
        this.end_offset = offset;
    }

    public boolean isChildOf(NLPNode node, String label) {
        return this.isChildOf(node) && this.isDependencyLabel(label);
    }

    public void addChild(NLPNode child, String label) {
        this.addChild(child);
        this.setDependencyLabel(label);
    }

    public NLPNode getLeftMostChild() {
        return this.getLeftMostChild(0);
    }

    public NLPNode getLeftMostChild(int order) {
        NLPNode node = (NLPNode)this.getFirstChild(order);
        return node != null && this.compareTo(node) < 0 ? node : null;
    }

    public NLPNode getRightMostChild() {
        return this.getRightMostChild(0);
    }

    public NLPNode getRightMostChild(int order) {
        NLPNode node = (NLPNode)this.getLastChild(order);
        return node != null && this.compareTo(node) > 0 ? node : null;
    }

    public NLPNode getLeftNearestChild() {
        return this.getLeftNearestChild(0);
    }

    public NLPNode getLeftNearestChild(int order) {
        return (NLPNode)this.getChild(this.getDefaultIndex((List<NLPNode>)this.children, this.self()) - order - 1);
    }

    public NLPNode getRightNearestChild() {
        return this.getRightNearestChild(0);
    }

    public NLPNode getRightNearestChild(int order) {
        return (NLPNode)this.getChild(this.getDefaultIndex((List<NLPNode>)this.children, this.self()) + order);
    }

    public List<NLPNode> getLeftChildren() {
        int index = this.getDefaultIndex((List<NLPNode>)this.children, this.self());
        return this.children.subList(0, index);
    }

    public List<NLPNode> getRightChildren() {
        int index = this.getDefaultIndex((List<NLPNode>)this.children, this.self());
        return this.children.subList(index, this.children.size());
    }

    public String getValency() {
        String l = this.getLeftValency();
        String r = this.getRightValency();
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return l + r;
    }

    public String getLeftValency() {
        if (this.getLeftMostChild(1) != null) {
            return "[[";
        }
        if (this.getLeftMostChild() != null) {
            return "[";
        }
        return null;
    }

    public String getRightValency() {
        if (this.getRightMostChild(1) != null) {
            return "]]";
        }
        if (this.getRightMostChild() != null) {
            return "]";
        }
        return null;
    }

    public void setParent(NLPNode parent, String label) {
        this.setParent(parent);
        this.setDependencyLabel(label);
    }

    public List<NLPArc> getSecondaryArcs() {
        return this.snd_parents;
    }

    public List<NLPArc> getSecondaryArcs(String label) {
        ArrayList<NLPArc> list = new ArrayList<NLPArc>();
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isLabel(label)) continue;
            list.add(arc);
        }
        return list;
    }

    public NLPArc getSecondaryArc(NLPNode node) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isNode(node)) continue;
            return arc;
        }
        return null;
    }

    public NLPArc getSecondaryArc(NLPNode node, String label) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.equals(node, label)) continue;
            return arc;
        }
        return null;
    }

    public NLPArc getSecondaryArc(NLPNode node, Pattern pattern) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.equals(node, pattern)) continue;
            return arc;
        }
        return null;
    }

    public String getSecondaryLabel(NLPNode node) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isNode(node)) continue;
            return arc.getLabel();
        }
        return null;
    }

    public NLPNode getFirstSecondaryParent(String label) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isLabel(label)) continue;
            return arc.getNode();
        }
        return null;
    }

    public NLPNode getFirstSecondaryParent(Pattern pattern) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isLabel(pattern)) continue;
            return arc.getNode();
        }
        return null;
    }

    public void addSecondaryArcs(Collection<NLPArc> arcs) {
        this.snd_parents.addAll(arcs);
    }

    public void addSecondaryArc(NLPNode head, String label) {
        this.addSecondaryArc(new NLPArc(head, label));
    }

    public void addSecondaryArc(NLPArc arc) {
        this.snd_parents.add(arc);
    }

    public void setSecondaryArcs(List<NLPArc> arcs) {
        this.snd_parents = arcs;
    }

    public boolean removeSecondaryArc(NLPNode node) {
        for (NLPArc arc : this.snd_parents) {
            if (!arc.isNode(node)) continue;
            return this.snd_parents.remove(arc);
        }
        return false;
    }

    public boolean removeSecondaryArc(NLPArc arc) {
        return this.snd_parents.remove(arc);
    }

    public void removeSecondaryArcs(Collection<NLPArc> arcs) {
        this.snd_parents.removeAll(arcs);
    }

    public void removeSecondaryArcs(String label) {
        this.snd_parents.removeAll(this.getSecondaryArcs(label));
    }

    public List<NLPArc> clearSecondaryArcs() {
        List<NLPArc> backup = this.snd_parents.subList(0, this.snd_parents.size());
        this.snd_parents.clear();
        return backup;
    }

    public boolean isSecondaryChildOf(NLPNode node) {
        return this.getSecondaryArc(node) != null;
    }

    public boolean isSecondaryChildOf(String label) {
        return this.getFirstSecondaryParent(label) != null;
    }

    public boolean isSecondaryChildOf(Pattern pattern) {
        return this.getFirstSecondaryParent(pattern) != null;
    }

    public boolean isSecondaryChildOf(NLPNode node, String label) {
        return this.getSecondaryArc(node, label) != null;
    }

    public boolean isSecondaryChildOf(NLPNode node, Pattern pattern) {
        return this.getSecondaryArc(node, pattern) != null;
    }

    @Override
    public int compareTo(NLPNode o) {
        return this.token_id - o.token_id;
    }
}

