/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.structure.node;

import cloud.elit.sdk.nlp.structure.node.NLPNode;
import java.io.Serializable;
import java.util.regex.Pattern;

public class NLPArc
implements Comparable<NLPArc>,
Serializable {
    protected NLPNode node;
    protected String label;
    protected double weight;

    public NLPArc(NLPNode node, String label, double weight) {
        this.set(node, label, weight);
    }

    public NLPArc(NLPNode node, String label) {
        this(node, label, 0.0);
    }

    public NLPNode getNode() {
        return this.node;
    }

    public String getLabel() {
        return this.label;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setNode(NLPNode node) {
        this.node = node;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void set(NLPNode node, String label, double weight) {
        this.setNode(node);
        this.setLabel(label);
        this.setWeight(weight);
    }

    public void clear() {
        this.set(null, null, 0.0);
    }

    public boolean isNode(NLPNode node) {
        return this.node == node;
    }

    public boolean isLabel(String label) {
        return label != null && label.equals(this.label);
    }

    public boolean isLabel(Pattern labels) {
        return this.label != null && labels.matcher(this.label).find();
    }

    public boolean equals(NLPNode node, String label) {
        return this.isNode(node) && this.isLabel(label);
    }

    public boolean equals(NLPNode node, Pattern labels) {
        return this.isNode(node) && this.isLabel(labels);
    }

    @Override
    public int compareTo(NLPArc arc) {
        return this.node.compareTo(arc.node);
    }

    public String toString() {
        return String.format("[%d, \"%s\"]", this.node.getTokenID(), this.label);
    }
}

