/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.structure.node;

import cloud.elit.sdk.util.DSUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.magicwerk.brownies.collections.GapList;

public abstract class AbstractNode<N extends AbstractNode<N>>
implements Serializable {
    protected int token_id;
    protected String token;
    protected String lemma;
    protected String syn_tag;
    protected String ner_tag;
    protected Map<String, String> feat_map;
    protected N parent;
    protected N left_sibling;
    protected N right_sibling;
    protected List<N> children;

    public AbstractNode(int token_id, String token, String lemma, String syn_tag, String ner_tag, Map<String, String> feat_map) {
        this.setTokenID(token_id);
        this.setToken(token);
        this.setLemma(lemma);
        this.setSyntacticTag(syn_tag);
        this.setNamedEntityTag(ner_tag);
        this.setFeatMap(feat_map);
        this.parent = null;
        this.left_sibling = null;
        this.right_sibling = null;
        this.children = new GapList();
    }

    public abstract N self();

    public abstract int getChildIndex(N var1);

    protected abstract int getDefaultIndex(List<N> var1, N var2);

    public int getTokenID() {
        return this.token_id;
    }

    public void setTokenID(int id) {
        this.token_id = id;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public String getSyntacticTag() {
        return this.syn_tag;
    }

    public void setSyntacticTag(String tag) {
        this.syn_tag = tag;
    }

    public String getNamedEntityTag() {
        return this.ner_tag;
    }

    public void setNamedEntityTag(String tag) {
        this.ner_tag = tag;
    }

    public Map<String, String> getFeatMap() {
        return this.feat_map;
    }

    public void setFeatMap(Map<String, String> map) {
        this.feat_map = map;
    }

    public String getFeat(String key) {
        return this.feat_map.get(key);
    }

    public String putFeat(String key, String value) {
        return this.feat_map.put(key, value);
    }

    public String removeFeat(String key) {
        return this.feat_map.remove(key);
    }

    public N getChild(int index) {
        return (N)(DSUtils.isRange(this.children, index) ? (AbstractNode)this.children.get(index) : null);
    }

    public N getFirstChild() {
        return this.getFirstChild(0);
    }

    public N getFirstChild(int order) {
        return this.getChild(order);
    }

    public N getFirstChild(Predicate<N> matcher) {
        return (N)((AbstractNode)DSUtils.getFirst(this.children, matcher));
    }

    public N getLastChild() {
        return this.getLastChild(0);
    }

    public N getLastChild(int order) {
        return this.getChild(this.children.size() - order - 1);
    }

    public N getLastChild(Predicate<N> matcher) {
        return (N)((AbstractNode)DSUtils.getLast(this.children, matcher));
    }

    public boolean addChild(N node) {
        return this.addChild(this.getDefaultIndex(this.children, node), node);
    }

    public boolean addChild(int index, N node) {
        if (!this.isParentOf(node)) {
            if (((AbstractNode)node).hasParent()) {
                ((AbstractNode)((AbstractNode)node).parent).removeChild(node);
            }
            ((AbstractNode)node).parent = this.self();
            this.children.add(index, node);
            this.setSiblings(this.getChild(index - 1), node);
            this.setSiblings(node, this.getChild(index + 1));
            return true;
        }
        return false;
    }

    public N setChild(int index, N node) {
        if (!this.isParentOf(node)) {
            if (((AbstractNode)node).hasParent()) {
                ((AbstractNode)((AbstractNode)node).parent).removeChild(node);
            }
            ((AbstractNode)node).parent = this.self();
            AbstractNode old = (AbstractNode)this.children.set(index, node);
            this.setSiblings(this.getChild(index - 1), node);
            this.setSiblings(node, this.getChild(index + 1));
            old.isolate();
            return (N)old;
        }
        return null;
    }

    public N removeChild(N node) {
        return this.removeChild(this.getChildIndex(node));
    }

    public N removeChild(int index) {
        if (DSUtils.isRange(this.children, index)) {
            this.setSiblings(this.getChild(index - 1), this.getChild(index + 1));
            AbstractNode node = (AbstractNode)this.children.remove(index);
            node.isolate();
            return (N)node;
        }
        return null;
    }

    public boolean replaceChild(N old_child, N new_child) {
        int index = this.getChildIndex(old_child);
        if (index >= 0) {
            if (((AbstractNode)new_child).hasParent()) {
                ((AbstractNode)((AbstractNode)new_child).parent).removeChild(new_child);
            }
            this.setChild(index, new_child);
            return true;
        }
        return false;
    }

    public void removeSelf() {
        N node = this.self();
        while (((AbstractNode)node).hasParent()) {
            N parent = ((AbstractNode)node).parent;
            ((AbstractNode)parent).removeChild(node);
            if (((AbstractNode)parent).hasChild()) break;
            node = parent;
        }
    }

    public boolean hasChild() {
        return !this.children.isEmpty();
    }

    public boolean isChildOf(N node) {
        return node != null && this.parent == node;
    }

    public boolean containsChild(Predicate<N> matcher) {
        return DSUtils.contains(this.children, matcher);
    }

    public int numChildren() {
        return this.children.size();
    }

    public List<N> getChildren() {
        return this.children;
    }

    public List<N> getChildren(int fst_id) {
        return this.children.subList(fst_id, this.numChildren());
    }

    public List<N> getChildren(int fst_id, int lst_id) {
        return this.children.subList(fst_id, lst_id);
    }

    public List<N> getChildren(Predicate<N> matcher) {
        return DSUtils.getMatchedList(this.children, matcher);
    }

    public List<N> getGrandChildren() {
        return this.getSecondOrder(AbstractNode::getChildren);
    }

    public N getFirstDescendant(Predicate<N> matcher) {
        return this.getFirstDescendantAux(this.children, matcher);
    }

    private N getFirstDescendantAux(Collection<N> nodes, Predicate<N> matcher) {
        for (AbstractNode<N> node : nodes) {
            if (matcher.test(node)) {
                return (N)node;
            }
            node = this.getFirstDescendantAux(node.children, matcher);
            if (node == null) continue;
            return (N)node;
        }
        return null;
    }

    public N getFirstLowestChainedDescendant(Predicate<N> matcher) {
        N descendant = null;
        for (N node = this.getFirstChild(matcher); node != null; node = ((AbstractNode)node).getFirstChild(matcher)) {
            descendant = node;
        }
        return descendant;
    }

    public List<N> getDescendants() {
        return this.flatten().collect(Collectors.toList());
    }

    public List<N> getDescendants(int depth) {
        ArrayList list = new ArrayList();
        return depth > 0 ? this.getDescendantListAux(depth - 1, this.self(), list) : list;
    }

    private List<N> getDescendantListAux(int depth, N node, List<N> list) {
        list.addAll(((AbstractNode)node).getChildren());
        if (depth-- > 0) {
            for (AbstractNode dep : ((AbstractNode)node).getChildren()) {
                this.getDescendantListAux(depth, dep, list);
            }
        }
        return list;
    }

    public void adaptDependents(N from) {
        for (AbstractNode d : new ArrayList<N>(((AbstractNode)from).children)) {
            d.setParent(this.self());
        }
    }

    public boolean isDescendantOf(N node) {
        return this.getNearestNode(n -> n == node, AbstractNode::getParent) != null;
    }

    public N getParent() {
        return this.parent;
    }

    public N getGrandParent() {
        return this.getAncestor(2);
    }

    public N getAncestor(int height) {
        return (N)this.getNode(height, n -> n.parent);
    }

    public N getLowestAncestor(Predicate<N> matcher) {
        return (N)this.getNearestNode(matcher, AbstractNode::getParent);
    }

    public N getHighestChainedAncestor(Predicate<N> matcher) {
        N node = this.parent;
        N ancestor = null;
        while (node != null && matcher.test(node)) {
            ancestor = node;
            node = ((AbstractNode)node).parent;
        }
        return ancestor;
    }

    public Set<N> getAncestorSet() {
        HashSet<N> set = new HashSet<N>();
        for (N node = this.getParent(); node != null; node = ((AbstractNode)node).getParent()) {
            set.add(node);
        }
        return set;
    }

    public N getLowestCommonAncestor(N node) {
        Set<N> set = this.getAncestorSet();
        set.add(this.self());
        while (node != null) {
            if (set.contains(node)) {
                return node;
            }
            node = ((AbstractNode)node).getParent();
        }
        return null;
    }

    public void setParent(N node) {
        if (node == null) {
            if (this.hasParent()) {
                ((AbstractNode)this.parent).removeChild(this.self());
            }
        } else {
            ((AbstractNode)node).addChild(this.self());
        }
    }

    public boolean isParentOf(N node) {
        return ((AbstractNode)node).isChildOf(this.self());
    }

    public boolean isAncestorOf(N node) {
        return ((AbstractNode)node).isDescendantOf(this.self());
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasParent(Predicate<N> matcher) {
        return this.hasParent() && matcher.test(this.parent);
    }

    public boolean hasGrandParent() {
        return this.getGrandParent() != null;
    }

    public List<N> getSiblings() {
        return this.hasParent() ? ((AbstractNode)this.parent).children.stream().filter(n -> n != this.self()).collect(Collectors.toList()) : new ArrayList();
    }

    public N getLeftNearestSibling() {
        return this.left_sibling;
    }

    public N getLeftNearestSibling(int order) {
        return (N)(order >= 0 ? this.getNode(order + 1, AbstractNode::getLeftNearestSibling) : null);
    }

    public N getLeftNearestSibling(Predicate<N> matcher) {
        return (N)this.getNearestNode(matcher, AbstractNode::getLeftNearestSibling);
    }

    public N getRightNearestSibling() {
        return this.right_sibling;
    }

    public N getRightNearestSibling(int order) {
        return (N)(order >= 0 ? this.getNode(order + 1, AbstractNode::getRightNearestSibling) : null);
    }

    public N getRightNearestSibling(Predicate<N> matcher) {
        return (N)this.getNearestNode(matcher, AbstractNode::getRightNearestSibling);
    }

    public boolean hasLeftSibling() {
        return this.left_sibling != null;
    }

    public boolean hasLeftSibling(Predicate<N> matcher) {
        return this.getLeftNearestSibling(matcher) != null;
    }

    public boolean hasRightSibling() {
        return this.right_sibling != null;
    }

    public boolean hasRightSibling(Predicate<N> matcher) {
        return this.getRightNearestSibling(matcher) != null;
    }

    public boolean isSiblingOf(N node) {
        return ((AbstractNode)node).isChildOf(this.parent);
    }

    public boolean isLeftSiblingOf(N node) {
        return node != null && this.parent == ((AbstractNode)node).parent && this.getNearestNode(n -> n == node, AbstractNode::getRightNearestSibling) != null;
    }

    public boolean isRightSiblingOf(N node) {
        return ((AbstractNode)node).isLeftSiblingOf(this.self());
    }

    public Stream<N> flatten() {
        return Stream.concat(Stream.of(this.self()), this.children.stream().flatMap(AbstractNode::flatten));
    }

    public N getNode(int order, Function<N, N> getter) {
        Object node = this.self();
        for (int i = 0; i < order; ++i) {
            if (node == null) {
                return node;
            }
            node = (AbstractNode)getter.apply(node);
        }
        return node;
    }

    public N getNearestNode(Predicate<N> matcher, Function<N, N> getter) {
        AbstractNode node = (AbstractNode)getter.apply(this.self());
        while (node != null) {
            if (matcher.test(node)) {
                return (N)node;
            }
            node = (AbstractNode)getter.apply(node);
        }
        return null;
    }

    public int distanceToTop() {
        N node = this.parent;
        int dist = 0;
        while (node != null) {
            node = ((AbstractNode)node).parent;
            ++dist;
        }
        return dist;
    }

    protected void isolate() {
        this.parent = null;
        this.left_sibling = null;
        this.right_sibling = null;
    }

    protected void setSiblings(N left, N right) {
        if (left != null) {
            ((AbstractNode)left).right_sibling = right;
        }
        if (right != null) {
            ((AbstractNode)right).left_sibling = left;
        }
    }

    protected List<N> getSecondOrder(Function<N, List<N>> getter) {
        return getter.apply(this.self()).stream().flatMap(n -> ((List)getter.apply(n)).stream()).filter(n -> n != this.self()).collect(Collectors.toList());
    }
}

