/*
 * Decompiled with CFR 0.152.
 */
package cloud.elit.sdk.nlp.structure;

import cloud.elit.sdk.nlp.structure.Chunk;
import cloud.elit.sdk.nlp.structure.node.AbstractNode;
import cloud.elit.sdk.nlp.structure.node.NLPNode;
import cloud.elit.sdk.nlp.structure.node.NLPNodeList;
import cloud.elit.sdk.nlp.structure.node.NLPUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Sentence
extends NLPNodeList
implements Iterable<NLPNode> {
    private int sen_id;
    private NLPNode root;
    private List<Chunk> ner_list;

    public Sentence(int sen_id, List<NLPNode> nodes) {
        super(nodes);
        this.setID(sen_id);
        this.root = NLPUtils.createRoot();
    }

    public Sentence(List<NLPNode> nodes) {
        this(-1, nodes);
    }

    public Sentence() {
        this(new ArrayList<NLPNode>());
    }

    public int getID() {
        return this.sen_id;
    }

    public void setID(int id) {
        this.sen_id = id;
    }

    public NLPNode getRoot() {
        return this.root;
    }

    public void setRoot(NLPNode node) {
        this.root = node;
    }

    public List<Chunk> getNamedEntities() {
        return this.ner_list;
    }

    public void setNamedEntities(List<Chunk> entities) {
        this.ner_list = entities;
    }

    public int numNamedEntities() {
        return this.ner_list.size();
    }

    public Chunk getNamedEntity(int index) {
        return this.ner_list.get(index);
    }

    public List<String> getTokens() {
        return this.nodes.stream().map(AbstractNode::getToken).collect(Collectors.toList());
    }

    public List<String> getLemmas() {
        return this.nodes.stream().map(AbstractNode::getLemma).collect(Collectors.toList());
    }

    public List<String> getPartOfSpeechTags() {
        return this.nodes.stream().map(NLPNode::getPartOfSpeechTag).collect(Collectors.toList());
    }

    @Override
    public Iterator<NLPNode> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",\n");
        NLPNode node = (NLPNode)this.nodes.get(0);
        joiner.add(String.format("  \"%s\": %d", "sid", this.sen_id));
        joiner.add(String.format("  \"%s\": %s", "tok", this.fromStringList(AbstractNode::getToken)));
        if (node.getEndOffset() > 0) {
            joiner.add(String.format("  \"%s\": %s", "off", this.fromOffsets()));
        }
        if (node.getLemma() != null) {
            joiner.add(String.format("  \"%s\": %s", "lem", this.fromStringList(AbstractNode::getLemma)));
        }
        if (node.getPartOfSpeechTag() != null) {
            joiner.add(String.format("  \"%s\": %s", "pos", this.fromStringList(NLPNode::getPartOfSpeechTag)));
        }
        if (this.ner_list != null) {
            joiner.add(String.format("  \"%s\": %s", "ner", this.ner_list.toString()));
        }
        if (node.getParent() != null) {
            joiner.add(String.format("  \"%s\": %s", "dep", this.fromPrimaryDependencies()));
        }
        return "{\n" + joiner.toString() + "\n}";
    }

    private String fromStringList(Function<NLPNode, String> f) {
        StringJoiner joiner = new StringJoiner(", ");
        for (NLPNode node : this.nodes) {
            joiner.add(String.format("\"%s\"", f.apply(node)));
        }
        return "[" + joiner.toString() + "]";
    }

    private String fromOffsets() {
        StringJoiner joiner = new StringJoiner(", ");
        for (NLPNode node : this.nodes) {
            joiner.add(String.format("[%d, %d]", node.getBeginOffset(), node.getEndOffset()));
        }
        return "[" + joiner.toString() + "]";
    }

    private String fromPrimaryDependencies() {
        StringJoiner joiner = new StringJoiner(", ");
        for (NLPNode node : this.nodes) {
            joiner.add(String.format("[%d, \"%s\"]", ((NLPNode)node.getParent()).getTokenID(), node.getDependencyLabel()));
        }
        return "[" + joiner.toString() + "]";
    }
}

